% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_get_open_id_token}
\alias{cognitoidentity_get_open_id_token}
\title{Gets an OpenID token, using a known Cognito ID}
\usage{
cognitoidentity_get_open_id_token(IdentityId, Logins)
}
\arguments{
\item{IdentityId}{[required] A unique identifier in the format REGION:GUID.}

\item{Logins}{A set of optional name-value pairs that map provider names to provider
tokens. When using graph.facebook.com and www.amazon.com, supply the
access\_token returned from the provider's authflow. For
accounts.google.com, an Amazon Cognito user pool provider, or any other
OpenId Connect provider, always include the \code{id_token}.}
}
\description{
Gets an OpenID token, using a known Cognito ID. This known Cognito ID is
returned by GetId. You can optionally add additional logins for the
identity. Supplying multiple logins creates an implicit link.
}
\details{
The OpenId token is valid for 10 minutes.

This is a public API. You do not need any credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$get_open_id_token(
  IdentityId = "string",
  Logins = list(
    "string"
  )
)
}
}

\keyword{internal}
