% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_sign_up}
\alias{cognitoidentityprovider_sign_up}
\title{Registers the user in the specified user pool and creates a user name,
password, and user attributes}
\usage{
cognitoidentityprovider_sign_up(ClientId, SecretHash, Username,
  Password, UserAttributes, ValidationData, AnalyticsMetadata,
  UserContextData)
}
\arguments{
\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{Username}{[required] The user name of the user you wish to register.}

\item{Password}{[required] The password of the user you wish to register.}

\item{UserAttributes}{An array of name-value pairs representing user attributes.

For custom attributes, you must prepend the \code{custom:} prefix to the
attribute name.}

\item{ValidationData}{The validation data in the request to register a user.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{SignUp} calls.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}
}
\description{
Registers the user in the specified user pool and creates a user name,
password, and user attributes.
}
\section{Request syntax}{
\preformatted{svc$sign_up(
  ClientId = "string",
  SecretHash = "string",
  Username = "string",
  Password = "string",
  UserAttributes = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  ValidationData = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  UserContextData = list(
    EncodedData = "string"
  )
)
}
}

\keyword{internal}
