% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_policy_version}
\alias{iam_create_policy_version}
\title{Creates a new version of the specified managed policy}
\usage{
iam_create_policy_version(PolicyArn, PolicyDocument, SetAsDefault)
}
\arguments{
\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy to which you want to
add a new version.

For more information about ARNs, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{PolicyDocument}{[required] The JSON policy document that you want to use as the content for this
new version of the policy.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} used to validate
this parameter is a string of characters consisting of the following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \code{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\code{U+000A}), and
carriage return (\code{U+000D})
}}

\item{SetAsDefault}{Specifies whether to set this version as the policy's default version.

When this parameter is \code{true}, the new policy version becomes the
operative version. That is, it becomes the version that is in effect for
the IAM users, groups, and roles that the policy is attached to.

For more information about managed policy versions, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html}{Versioning for Managed Policies}
in the \emph{IAM User Guide}.}
}
\description{
Creates a new version of the specified managed policy. To update a
managed policy, you create a new policy version. A managed policy can
have up to five versions. If the policy has five versions, you must
delete an existing version using DeletePolicyVersion before you create a
new version.
}
\details{
Optionally, you can set the new version as the policy's default
version. The default version is the version that is in effect for the
IAM users, groups, and roles to which the policy is attached.

For more information about managed policy versions, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html}{Versioning for Managed Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_policy_version(
  PolicyArn = "string",
  PolicyDocument = "string",
  SetAsDefault = TRUE|FALSE
)
}
}

\keyword{internal}
