% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_generate_data_key}
\alias{kms_generate_data_key}
\title{Returns a data encryption key that you can use in your application to
encrypt data locally}
\usage{
kms_generate_data_key(KeyId, EncryptionContext, NumberOfBytes, KeySpec,
  GrantTokens)
}
\arguments{
\item{KeyId}{[required] The identifier of the CMK under which to generate and encrypt the data
encryption key.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with "alias/".
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{EncryptionContext}{A set of key-value pairs that represents additional authenticated data.

For more information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html}{Encryption Context}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{NumberOfBytes}{The length of the data encryption key in bytes. For example, use the
value 64 to generate a 512-bit data key (64 bytes is 512 bits). For
common key lengths (128-bit and 256-bit symmetric keys), we recommend
that you use the \code{KeySpec} field instead of this one.}

\item{KeySpec}{The length of the data encryption key. Use \code{AES_128} to generate a
128-bit symmetric key, or \code{AES_256} to generate a 256-bit symmetric key.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Returns a data encryption key that you can use in your application to
encrypt data locally.
}
\details{
You must specify the customer master key (CMK) under which to generate
the data key. You must also specify the length of the data key using
either the \code{KeySpec} or \code{NumberOfBytes} field. You must specify one
field or the other, but not both. For common key lengths (128-bit and
256-bit symmetric keys), we recommend that you use \code{KeySpec}. To perform
this operation on a CMK in a different AWS account, specify the key ARN
or alias ARN in the value of the KeyId parameter.

This operation returns a plaintext copy of the data key in the
\code{Plaintext} field of the response, and an encrypted copy of the data key
in the \code{CiphertextBlob} field. The data key is encrypted under the CMK
specified in the \code{KeyId} field of the request.

We recommend that you use the following pattern to encrypt data locally
in your application:
\enumerate{
\item Use this operation (\code{GenerateDataKey}) to get a data encryption key.
\item Use the plaintext data encryption key (returned in the \code{Plaintext}
field of the response) to encrypt data locally, then erase the
plaintext data key from memory.
\item Store the encrypted data key (returned in the \code{CiphertextBlob} field
of the response) alongside the locally encrypted data.
}

To decrypt data locally:
\enumerate{
\item Use the Decrypt operation to decrypt the encrypted data key into a
plaintext copy of the data key.
\item Use the plaintext data key to decrypt data locally, then erase the
plaintext data key from memory.
}

To return only an encrypted copy of the data key, use
GenerateDataKeyWithoutPlaintext. To return a random byte string that is
cryptographically secure, use GenerateRandom.

If you use the optional \code{EncryptionContext} field, you must store at
least enough information to be able to reconstruct the full encryption
context when you later send the ciphertext to the Decrypt operation. It
is a good practice to choose an encryption context that you can
reconstruct on the fly to better secure the ciphertext. For more
information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html}{Encryption Context}
in the \emph{AWS Key Management Service Developer Guide}.

The result of this operation varies with the key state of the CMK. For
details, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$generate_data_key(
  KeyId = "string",
  EncryptionContext = list(
    "string"
  ),
  NumberOfBytes = 123,
  KeySpec = "AES_256"|"AES_128",
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
# The following example generates a 256-bit symmetric data encryption key
# (data key) in two formats. One is the unencrypted (plainext) data key,
# and the other is the data key encrypted with the specified customer
# master key (CMK).
\donttest{svc$generate_data_key(
  KeyId = "alias/ExampleAlias",
  KeySpec = "AES_256"
)}

}
\keyword{internal}
