% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_rule_group}
\alias{wafregional_create_rule_group}
\title{Creates a RuleGroup}
\usage{
wafregional_create_rule_group(Name, MetricName, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description of the RuleGroup. You can't change
\code{Name} after you create a \code{RuleGroup}.}

\item{MetricName}{[required] A friendly name or description for the metrics for this \code{RuleGroup}. The
name can contain only alphanumeric characters (A-Z, a-z, 0-9); the name
can't contain whitespace. You can't change the name of the metric
after you create the \code{RuleGroup}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Creates a \code{RuleGroup}. A rule group is a collection of predefined rules
that you add to a web ACL. You use UpdateRuleGroup to add rules to the
rule group.
}
\details{
Rule groups are subject to the following limits:
\itemize{
\item Three rule groups per account. You can request an increase to this
limit by contacting customer support.
\item One rule group per web ACL.
\item Ten rules per rule group.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_rule_group(
  Name = "string",
  MetricName = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
