% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_confirm_sign_up}
\alias{cognitoidentityprovider_admin_confirm_sign_up}
\title{Confirms user registration as an admin without using a confirmation code}
\usage{
cognitoidentityprovider_admin_confirm_sign_up(UserPoolId, Username,
  ClientMetadata)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for which you want to confirm user registration.}

\item{Username}{[required] The user name for which you want to confirm user registration.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

If your user pool configuration includes triggers, the
AdminConfirmSignUp API action invokes the AWS Lambda function that is
specified for the \emph{post confirmation} trigger. When Amazon Cognito
invokes this function, it passes a JSON payload, which the function
receives as input. In this payload, the \code{clientMetadata} attribute
provides the data that you assigned to the ClientMetadata parameter in
your AdminConfirmSignUp request. In your function code in AWS Lambda,
you can process the ClientMetadata value to enhance your workflow for
your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing User Pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

Take the following limitations into consideration when you use the
ClientMetadata parameter:
\itemize{
\item Amazon Cognito does not store the ClientMetadata value. This data is
available only to AWS Lambda triggers that are assigned to a user
pool to support custom workflows. If your user pool configuration
does not include triggers, the ClientMetadata parameter serves no
purpose.
\item Amazon Cognito does not validate the ClientMetadata value.
\item Amazon Cognito does not encrypt the the ClientMetadata value, so
don't use it to provide sensitive information.
}}
}
\description{
Confirms user registration as an admin without using a confirmation
code. Works on any user.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_confirm_sign_up(
  UserPoolId = "string",
  Username = "string",
  ClientMetadata = list(
    "string"
  )
)
}
}

\keyword{internal}
