% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_alias}
\alias{kms_create_alias}
\title{Creates a friendly name for a customer master key (CMK)}
\usage{
kms_create_alias(AliasName, TargetKeyId)
}
\arguments{
\item{AliasName}{[required] Specifies the alias name. This value must begin with \verb{alias/} followed
by a name, such as \code{alias/ExampleAlias}.

The \code{AliasName} value must be string of 1-256 characters. It can contain
only alphanumeric characters, forward slashes (/), underscores (\\_), and
dashes (-). The alias name cannot begin with \verb{alias/aws/}. The
\verb{alias/aws/} prefix is reserved for \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{AWS managed CMKs}.}

\item{TargetKeyId}{[required] Associates the alias with the specified \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{customer managed CMK}.
The CMK must be in the same AWS Region.

A valid CMK ID is required. If you supply a null or empty string value,
this operation returns an error.

For help finding the key ID and ARN, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn}{Finding the Key ID and ARN}
in the \emph{AWS Key Management Service Developer Guide}.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}
}
\description{
Creates a friendly name for a customer master key (CMK). You can use an
alias to identify a CMK in the AWS KMS console, in the DescribeKey
operation and in \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations}{cryptographic operations},
such as Encrypt and GenerateDataKey.

You can also change the CMK that's associated with the alias
(UpdateAlias) or delete the alias (DeleteAlias) at any time. These
operations don't affect the underlying CMK.

You can associate the alias with any customer managed CMK in the same
AWS Region. Each alias is associated with only on CMK at a time, but a
CMK can have multiple aliases. A valid CMK is required. You can't create
an alias without a CMK.

The alias must be unique in the account and Region, but you can have
aliases with the same name in different Regions. For detailed
information about aliases, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html}{Using aliases}
in the \emph{AWS Key Management Service Developer Guide}.

This operation does not return a response. To get the alias that you
created, use the ListAliases operation.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on an alias
in a different AWS account.

\strong{Required permissions}
\itemize{
\item \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:CreateAlias}
on the alias (IAM policy).
\item \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:CreateAlias}
on the CMK (key policy).
}

For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access}{Controlling access to aliases}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Related operations:}
\itemize{
\item DeleteAlias
\item ListAliases
\item UpdateAlias
}
}
\section{Request syntax}{
\preformatted{svc$create_alias(
  AliasName = "string",
  TargetKeyId = "string"
)
}
}

\examples{
\dontrun{
# The following example creates an alias for the specified customer master
# key (CMK).
svc$create_alias(
  AliasName = "alias/ExampleAlias",
  TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
