% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_rate_based_rule}
\alias{wafregional_create_rate_based_rule}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_create_rate_based_rule(Name, MetricName, RateKey, RateLimit,
  ChangeToken, Tags)
}
\arguments{
\item{Name}{[required] A friendly name or description of the RateBasedRule. You can't change
the name of a \code{RateBasedRule} after you create it.}

\item{MetricName}{[required] A friendly name or description for the metrics for this \code{RateBasedRule}.
The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
maximum length 128 and minimum length one. It can't contain whitespace
or metric names reserved for AWS WAF, including "All" and
"Default\\_Action." You can't change the name of the metric after you
create the \code{RateBasedRule}.}

\item{RateKey}{[required] The field that AWS WAF uses to determine if requests are likely arriving
from a single source and thus subject to rate monitoring. The only valid
value for \code{RateKey} is \code{IP}. \code{IP} indicates that requests that arrive
from the same IP address are subject to the \code{RateLimit} that is
specified in the \code{RateBasedRule}.}

\item{RateLimit}{[required] The maximum number of requests, which have an identical value in the
field that is specified by \code{RateKey}, allowed in a five-minute period.
If the number of requests exceeds the \code{RateLimit} and the other
predicates specified in the rule are also met, AWS WAF triggers the
action that is specified for this rule.}

\item{ChangeToken}{[required] The \code{ChangeToken} that you used to submit the \code{CreateRateBasedRule}
request. You can also use this value to query the status of the request.
For more information, see GetChangeTokenStatus.}

\item{Tags}{}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Creates a RateBasedRule. The \code{RateBasedRule} contains a \code{RateLimit},
which specifies the maximum number of requests that AWS WAF allows from
a specified IP address in a five-minute period. The \code{RateBasedRule} also
contains the \code{IPSet} objects, \code{ByteMatchSet} objects, and other
predicates that identify the requests that you want to count or block if
these requests exceed the \code{RateLimit}.

If you add more than one predicate to a \code{RateBasedRule}, a request not
only must exceed the \code{RateLimit}, but it also must match all the
conditions to be counted or blocked. For example, suppose you add the
following to a \code{RateBasedRule}:
\itemize{
\item An \code{IPSet} that matches the IP address \verb{192.0.2.44/32}
\item A \code{ByteMatchSet} that matches \code{BadBot} in the \code{User-Agent} header
}

Further, you specify a \code{RateLimit} of 1,000.

You then add the \code{RateBasedRule} to a \code{WebACL} and specify that you want
to block requests that meet the conditions in the rule. For a request to
be blocked, it must come from the IP address 192.0.2.44 \emph{and} the
\code{User-Agent} header in the request must contain the value \code{BadBot}.
Further, requests that match these two conditions must be received at a
rate of more than 1,000 requests every five minutes. If both conditions
are met and the rate is exceeded, AWS WAF blocks the requests. If the
rate drops below 1,000 for a five-minute period, AWS WAF no longer
blocks the requests.

As a second example, suppose you want to limit requests to a particular
page on your site. To do this, you could add the following to a
\code{RateBasedRule}:
\itemize{
\item A \code{ByteMatchSet} with \code{FieldToMatch} of \code{URI}
\item A \code{PositionalConstraint} of \code{STARTS_WITH}
\item A \code{TargetString} of \code{login}
}

Further, you specify a \code{RateLimit} of 1,000.

By adding this \code{RateBasedRule} to a \code{WebACL}, you could limit requests
to your login page without affecting the rest of your site.

To create and configure a \code{RateBasedRule}, perform the following steps:
\enumerate{
\item Create and update the predicates that you want to include in the
rule. For more information, see CreateByteMatchSet, CreateIPSet, and
CreateSqlInjectionMatchSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateRule} request.
\item Submit a \code{CreateRateBasedRule} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateRule request.
\item Submit an \code{UpdateRateBasedRule} request to specify the predicates
that you want to include in the rule.
\item Create and update a \code{WebACL} that contains the \code{RateBasedRule}. For
more information, see CreateWebACL.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_rate_based_rule(
  Name = "string",
  MetricName = "string",
  RateKey = "IP",
  RateLimit = 123,
  ChangeToken = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
