% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_create_assessment_target}
\alias{inspector_create_assessment_target}
\title{Creates a new assessment target using the ARN of the resource group that
is generated by CreateResourceGroup}
\usage{
inspector_create_assessment_target(assessmentTargetName,
  resourceGroupArn)
}
\arguments{
\item{assessmentTargetName}{[required] The user-defined name that identifies the assessment target that you
want to create. The name must be unique within the AWS account.}

\item{resourceGroupArn}{The ARN that specifies the resource group that is used to create the
assessment target. If resourceGroupArn is not specified, all EC2
instances in the current AWS account and region are included in the
assessment target.}
}
\value{
A list with the following syntax:\preformatted{list(
  assessmentTargetArn = "string"
)
}
}
\description{
Creates a new assessment target using the ARN of the resource group that
is generated by
\code{\link[=inspector_create_resource_group]{create_resource_group}}. If
resourceGroupArn is not specified, all EC2 instances in the current AWS
account and region are included in the assessment target. If the
\href{https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html}{service-linked role}
isn’t already registered, this action also creates and registers a
service-linked role to grant Amazon Inspector access to AWS Services
needed to perform security assessments. You can create up to 50
assessment targets per AWS account. You can run up to 500 concurrent
agents per AWS account. For more information, see \href{https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html}{Amazon Inspector Assessment Targets}.
}
\section{Request syntax}{
\preformatted{svc$create_assessment_target(
  assessmentTargetName = "string",
  resourceGroupArn = "string"
)
}
}

\examples{
\dontrun{
# Creates a new assessment target using the ARN of the resource group that
# is generated by CreateResourceGroup. You can create up to 50 assessment
# targets per AWS account. You can run up to 500 concurrent agents per AWS
# account.
svc$create_assessment_target(
  assessmentTargetName = "ExampleAssessmentTarget",
  resourceGroupArn = "arn:aws:inspector:us-west-2:123456789012:resourcegroup/0-AB6DMKnv"
)
}

}
\keyword{internal}
