# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cognitosync_service.R
NULL

#' Initiates a bulk publish of all existing datasets for an Identity Pool
#' to the configured stream
#'
#' @description
#' Initiates a bulk publish of all existing datasets for an Identity Pool
#' to the configured stream. Customers are limited to one successful bulk
#' publish per 24 hours. Bulk publish is an asynchronous request, customers
#' can see the status of the request via the GetBulkPublishDetails
#' operation.
#' 
#' This API can only be called with developer credentials. You cannot call
#' this API with the temporary user credentials provided by Cognito
#' Identity.
#'
#' @usage
#' cognitosync_bulk_publish(IdentityPoolId)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityPoolId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$bulk_publish(
#'   IdentityPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_bulk_publish
cognitosync_bulk_publish <- function(IdentityPoolId) {
  op <- new_operation(
    name = "BulkPublish",
    http_method = "POST",
    http_path = "/identitypools/{IdentityPoolId}/bulkpublish",
    paginator = list()
  )
  input <- .cognitosync$bulk_publish_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitosync$bulk_publish_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$bulk_publish <- cognitosync_bulk_publish

#' Deletes the specific dataset
#'
#' @description
#' Deletes the specific dataset. The dataset will be deleted permanently,
#' and the action can't be undone. Datasets that this dataset was merged
#' with will no longer report the merge. Any subsequent operation on this
#' dataset will result in a ResourceNotFoundException.
#' 
#' This API can be called with temporary user credentials provided by
#' Cognito Identity or with developer credentials.
#'
#' @usage
#' cognitosync_delete_dataset(IdentityPoolId, IdentityId, DatasetName)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param IdentityId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param DatasetName &#91;required&#93; A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9,
#' '_' (underscore), '-' (dash), and '.' (dot).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Dataset = list(
#'     IdentityId = "string",
#'     DatasetName = "string",
#'     CreationDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedBy = "string",
#'     DataStorage = 123,
#'     NumRecords = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_dataset(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   DatasetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_delete_dataset
cognitosync_delete_dataset <- function(IdentityPoolId, IdentityId, DatasetName) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "DELETE",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
    paginator = list()
  )
  input <- .cognitosync$delete_dataset_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, DatasetName = DatasetName)
  output <- .cognitosync$delete_dataset_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$delete_dataset <- cognitosync_delete_dataset

#' Gets meta data about a dataset by identity and dataset name
#'
#' @description
#' Gets meta data about a dataset by identity and dataset name. With Amazon
#' Cognito Sync, each identity has access only to its own data. Thus, the
#' credentials used to make this API call need to have access to the
#' identity data.
#' 
#' This API can be called with temporary user credentials provided by
#' Cognito Identity or with developer credentials. You should use Cognito
#' Identity credentials to make this API call.
#'
#' @usage
#' cognitosync_describe_dataset(IdentityPoolId, IdentityId, DatasetName)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param IdentityId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param DatasetName &#91;required&#93; A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9,
#' '_' (underscore), '-' (dash), and '.' (dot).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Dataset = list(
#'     IdentityId = "string",
#'     DatasetName = "string",
#'     CreationDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedBy = "string",
#'     DataStorage = 123,
#'     NumRecords = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_dataset(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   DatasetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_describe_dataset
cognitosync_describe_dataset <- function(IdentityPoolId, IdentityId, DatasetName) {
  op <- new_operation(
    name = "DescribeDataset",
    http_method = "GET",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
    paginator = list()
  )
  input <- .cognitosync$describe_dataset_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, DatasetName = DatasetName)
  output <- .cognitosync$describe_dataset_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$describe_dataset <- cognitosync_describe_dataset

#' Gets usage details (for example, data storage) about a particular
#' identity pool
#'
#' @description
#' Gets usage details (for example, data storage) about a particular
#' identity pool.
#' 
#' This API can only be called with developer credentials. You cannot call
#' this API with the temporary user credentials provided by Cognito
#' Identity.
#'
#' @usage
#' cognitosync_describe_identity_pool_usage(IdentityPoolId)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityPoolUsage = list(
#'     IdentityPoolId = "string",
#'     SyncSessionsCount = 123,
#'     DataStorage = 123,
#'     LastModifiedDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_identity_pool_usage(
#'   IdentityPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_describe_identity_pool_usage
cognitosync_describe_identity_pool_usage <- function(IdentityPoolId) {
  op <- new_operation(
    name = "DescribeIdentityPoolUsage",
    http_method = "GET",
    http_path = "/identitypools/{IdentityPoolId}",
    paginator = list()
  )
  input <- .cognitosync$describe_identity_pool_usage_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitosync$describe_identity_pool_usage_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$describe_identity_pool_usage <- cognitosync_describe_identity_pool_usage

#' Gets usage information for an identity, including number of datasets and
#' data usage
#'
#' @description
#' Gets usage information for an identity, including number of datasets and
#' data usage.
#' 
#' This API can be called with temporary user credentials provided by
#' Cognito Identity or with developer credentials.
#'
#' @usage
#' cognitosync_describe_identity_usage(IdentityPoolId, IdentityId)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param IdentityId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityUsage = list(
#'     IdentityId = "string",
#'     IdentityPoolId = "string",
#'     LastModifiedDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DatasetCount = 123,
#'     DataStorage = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_identity_usage(
#'   IdentityPoolId = "string",
#'   IdentityId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_describe_identity_usage
cognitosync_describe_identity_usage <- function(IdentityPoolId, IdentityId) {
  op <- new_operation(
    name = "DescribeIdentityUsage",
    http_method = "GET",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}",
    paginator = list()
  )
  input <- .cognitosync$describe_identity_usage_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId)
  output <- .cognitosync$describe_identity_usage_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$describe_identity_usage <- cognitosync_describe_identity_usage

#' Get the status of the last BulkPublish operation for an identity pool
#'
#' @description
#' Get the status of the last BulkPublish operation for an identity pool.
#' 
#' This API can only be called with developer credentials. You cannot call
#' this API with the temporary user credentials provided by Cognito
#' Identity.
#'
#' @usage
#' cognitosync_get_bulk_publish_details(IdentityPoolId)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityPoolId = "string",
#'   BulkPublishStartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   BulkPublishCompleteTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   BulkPublishStatus = "NOT_STARTED"|"IN_PROGRESS"|"FAILED"|"SUCCEEDED",
#'   FailureMessage = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bulk_publish_details(
#'   IdentityPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_get_bulk_publish_details
cognitosync_get_bulk_publish_details <- function(IdentityPoolId) {
  op <- new_operation(
    name = "GetBulkPublishDetails",
    http_method = "POST",
    http_path = "/identitypools/{IdentityPoolId}/getBulkPublishDetails",
    paginator = list()
  )
  input <- .cognitosync$get_bulk_publish_details_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitosync$get_bulk_publish_details_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$get_bulk_publish_details <- cognitosync_get_bulk_publish_details

#' Gets the events and the corresponding Lambda functions associated with
#' an identity pool
#'
#' @description
#' Gets the events and the corresponding Lambda functions associated with
#' an identity pool.
#' 
#' This API can only be called with developer credentials. You cannot call
#' this API with the temporary user credentials provided by Cognito
#' Identity.
#'
#' @usage
#' cognitosync_get_cognito_events(IdentityPoolId)
#'
#' @param IdentityPoolId &#91;required&#93; The Cognito Identity Pool ID for the request
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Events = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cognito_events(
#'   IdentityPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_get_cognito_events
cognitosync_get_cognito_events <- function(IdentityPoolId) {
  op <- new_operation(
    name = "GetCognitoEvents",
    http_method = "GET",
    http_path = "/identitypools/{IdentityPoolId}/events",
    paginator = list()
  )
  input <- .cognitosync$get_cognito_events_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitosync$get_cognito_events_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$get_cognito_events <- cognitosync_get_cognito_events

#' Gets the configuration settings of an identity pool
#'
#' @description
#' Gets the configuration settings of an identity pool.
#' 
#' This API can only be called with developer credentials. You cannot call
#' this API with the temporary user credentials provided by Cognito
#' Identity.
#'
#' @usage
#' cognitosync_get_identity_pool_configuration(IdentityPoolId)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. This is the ID of the pool for which to return a configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityPoolId = "string",
#'   PushSync = list(
#'     ApplicationArns = list(
#'       "string"
#'     ),
#'     RoleArn = "string"
#'   ),
#'   CognitoStreams = list(
#'     StreamName = "string",
#'     RoleArn = "string",
#'     StreamingStatus = "ENABLED"|"DISABLED"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_identity_pool_configuration(
#'   IdentityPoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_get_identity_pool_configuration
cognitosync_get_identity_pool_configuration <- function(IdentityPoolId) {
  op <- new_operation(
    name = "GetIdentityPoolConfiguration",
    http_method = "GET",
    http_path = "/identitypools/{IdentityPoolId}/configuration",
    paginator = list()
  )
  input <- .cognitosync$get_identity_pool_configuration_input(IdentityPoolId = IdentityPoolId)
  output <- .cognitosync$get_identity_pool_configuration_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$get_identity_pool_configuration <- cognitosync_get_identity_pool_configuration

#' Lists datasets for an identity
#'
#' @description
#' Lists datasets for an identity. With Amazon Cognito Sync, each identity
#' has access only to its own data. Thus, the credentials used to make this
#' API call need to have access to the identity data.
#' 
#' ListDatasets can be called with temporary user credentials provided by
#' Cognito Identity or with developer credentials. You should use the
#' Cognito Identity credentials to make this API call.
#'
#' @usage
#' cognitosync_list_datasets(IdentityPoolId, IdentityId, NextToken,
#'   MaxResults)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param IdentityId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param NextToken A pagination token for obtaining the next page of results.
#' @param MaxResults The maximum number of results to be returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Datasets = list(
#'     list(
#'       IdentityId = "string",
#'       DatasetName = "string",
#'       CreationDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedBy = "string",
#'       DataStorage = 123,
#'       NumRecords = 123
#'     )
#'   ),
#'   Count = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_datasets(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_list_datasets
cognitosync_list_datasets <- function(IdentityPoolId, IdentityId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "GET",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets",
    paginator = list()
  )
  input <- .cognitosync$list_datasets_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cognitosync$list_datasets_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$list_datasets <- cognitosync_list_datasets

#' Gets a list of identity pools registered with Cognito
#'
#' @description
#' Gets a list of identity pools registered with Cognito.
#' 
#' ListIdentityPoolUsage can only be called with developer credentials. You
#' cannot make this API call with the temporary user credentials provided
#' by Cognito Identity.
#'
#' @usage
#' cognitosync_list_identity_pool_usage(NextToken, MaxResults)
#'
#' @param NextToken A pagination token for obtaining the next page of results.
#' @param MaxResults The maximum number of results to be returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityPoolUsages = list(
#'     list(
#'       IdentityPoolId = "string",
#'       SyncSessionsCount = 123,
#'       DataStorage = 123,
#'       LastModifiedDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   Count = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_identity_pool_usage(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_list_identity_pool_usage
cognitosync_list_identity_pool_usage <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListIdentityPoolUsage",
    http_method = "GET",
    http_path = "/identitypools",
    paginator = list()
  )
  input <- .cognitosync$list_identity_pool_usage_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .cognitosync$list_identity_pool_usage_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$list_identity_pool_usage <- cognitosync_list_identity_pool_usage

#' Gets paginated records, optionally changed after a particular sync count
#' for a dataset and identity
#'
#' @description
#' Gets paginated records, optionally changed after a particular sync count
#' for a dataset and identity. With Amazon Cognito Sync, each identity has
#' access only to its own data. Thus, the credentials used to make this API
#' call need to have access to the identity data.
#' 
#' ListRecords can be called with temporary user credentials provided by
#' Cognito Identity or with developer credentials. You should use Cognito
#' Identity credentials to make this API call.
#'
#' @usage
#' cognitosync_list_records(IdentityPoolId, IdentityId, DatasetName,
#'   LastSyncCount, NextToken, MaxResults, SyncSessionToken)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param IdentityId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param DatasetName &#91;required&#93; A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9,
#' '_' (underscore), '-' (dash), and '.' (dot).
#' @param LastSyncCount The last server sync count for this record.
#' @param NextToken A pagination token for obtaining the next page of results.
#' @param MaxResults The maximum number of results to be returned.
#' @param SyncSessionToken A token containing a session ID, identity ID, and expiration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Records = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       SyncCount = 123,
#'       LastModifiedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedBy = "string",
#'       DeviceLastModifiedDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   Count = 123,
#'   DatasetSyncCount = 123,
#'   LastModifiedBy = "string",
#'   MergedDatasetNames = list(
#'     "string"
#'   ),
#'   DatasetExists = TRUE|FALSE,
#'   DatasetDeletedAfterRequestedSyncCount = TRUE|FALSE,
#'   SyncSessionToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_records(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   DatasetName = "string",
#'   LastSyncCount = 123,
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SyncSessionToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_list_records
cognitosync_list_records <- function(IdentityPoolId, IdentityId, DatasetName, LastSyncCount = NULL, NextToken = NULL, MaxResults = NULL, SyncSessionToken = NULL) {
  op <- new_operation(
    name = "ListRecords",
    http_method = "GET",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records",
    paginator = list()
  )
  input <- .cognitosync$list_records_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, DatasetName = DatasetName, LastSyncCount = LastSyncCount, NextToken = NextToken, MaxResults = MaxResults, SyncSessionToken = SyncSessionToken)
  output <- .cognitosync$list_records_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$list_records <- cognitosync_list_records

#' Registers a device to receive push sync notifications
#'
#' @description
#' Registers a device to receive push sync notifications.
#' 
#' This API can only be called with temporary credentials provided by
#' Cognito Identity. You cannot call this API with developer credentials.
#'
#' @usage
#' cognitosync_register_device(IdentityPoolId, IdentityId, Platform, Token)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. Here, the ID of the pool that the identity belongs to.
#' @param IdentityId &#91;required&#93; The unique ID for this identity.
#' @param Platform &#91;required&#93; The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).
#' @param Token &#91;required&#93; The push token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DeviceId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$register_device(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   Platform = "APNS"|"APNS_SANDBOX"|"GCM"|"ADM",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_register_device
cognitosync_register_device <- function(IdentityPoolId, IdentityId, Platform, Token) {
  op <- new_operation(
    name = "RegisterDevice",
    http_method = "POST",
    http_path = "/identitypools/{IdentityPoolId}/identity/{IdentityId}/device",
    paginator = list()
  )
  input <- .cognitosync$register_device_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, Platform = Platform, Token = Token)
  output <- .cognitosync$register_device_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$register_device <- cognitosync_register_device

#' Sets the AWS Lambda function for a given event type for an identity pool
#'
#' @description
#' Sets the AWS Lambda function for a given event type for an identity
#' pool. This request only updates the key/value pair specified. Other
#' key/values pairs are not updated. To remove a key value pair, pass a
#' empty value for the particular key.
#' 
#' This API can only be called with developer credentials. You cannot call
#' this API with the temporary user credentials provided by Cognito
#' Identity.
#'
#' @usage
#' cognitosync_set_cognito_events(IdentityPoolId, Events)
#'
#' @param IdentityPoolId &#91;required&#93; The Cognito Identity Pool to use when configuring Cognito Events
#' @param Events &#91;required&#93; The events to configure
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$set_cognito_events(
#'   IdentityPoolId = "string",
#'   Events = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_set_cognito_events
cognitosync_set_cognito_events <- function(IdentityPoolId, Events) {
  op <- new_operation(
    name = "SetCognitoEvents",
    http_method = "POST",
    http_path = "/identitypools/{IdentityPoolId}/events",
    paginator = list()
  )
  input <- .cognitosync$set_cognito_events_input(IdentityPoolId = IdentityPoolId, Events = Events)
  output <- .cognitosync$set_cognito_events_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$set_cognito_events <- cognitosync_set_cognito_events

#' Sets the necessary configuration for push sync
#'
#' @description
#' Sets the necessary configuration for push sync.
#' 
#' This API can only be called with developer credentials. You cannot call
#' this API with the temporary user credentials provided by Cognito
#' Identity.
#'
#' @usage
#' cognitosync_set_identity_pool_configuration(IdentityPoolId, PushSync,
#'   CognitoStreams)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. This is the ID of the pool to modify.
#' @param PushSync Options to apply to this identity pool for push synchronization.
#' @param CognitoStreams Options to apply to this identity pool for Amazon Cognito streams.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityPoolId = "string",
#'   PushSync = list(
#'     ApplicationArns = list(
#'       "string"
#'     ),
#'     RoleArn = "string"
#'   ),
#'   CognitoStreams = list(
#'     StreamName = "string",
#'     RoleArn = "string",
#'     StreamingStatus = "ENABLED"|"DISABLED"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$set_identity_pool_configuration(
#'   IdentityPoolId = "string",
#'   PushSync = list(
#'     ApplicationArns = list(
#'       "string"
#'     ),
#'     RoleArn = "string"
#'   ),
#'   CognitoStreams = list(
#'     StreamName = "string",
#'     RoleArn = "string",
#'     StreamingStatus = "ENABLED"|"DISABLED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_set_identity_pool_configuration
cognitosync_set_identity_pool_configuration <- function(IdentityPoolId, PushSync = NULL, CognitoStreams = NULL) {
  op <- new_operation(
    name = "SetIdentityPoolConfiguration",
    http_method = "POST",
    http_path = "/identitypools/{IdentityPoolId}/configuration",
    paginator = list()
  )
  input <- .cognitosync$set_identity_pool_configuration_input(IdentityPoolId = IdentityPoolId, PushSync = PushSync, CognitoStreams = CognitoStreams)
  output <- .cognitosync$set_identity_pool_configuration_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$set_identity_pool_configuration <- cognitosync_set_identity_pool_configuration

#' Subscribes to receive notifications when a dataset is modified by
#' another device
#'
#' @description
#' Subscribes to receive notifications when a dataset is modified by
#' another device.
#' 
#' This API can only be called with temporary credentials provided by
#' Cognito Identity. You cannot call this API with developer credentials.
#'
#' @usage
#' cognitosync_subscribe_to_dataset(IdentityPoolId, IdentityId,
#'   DatasetName, DeviceId)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. The ID of the pool to which the identity belongs.
#' @param IdentityId &#91;required&#93; Unique ID for this identity.
#' @param DatasetName &#91;required&#93; The name of the dataset to subcribe to.
#' @param DeviceId &#91;required&#93; The unique ID generated for this device by Cognito.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$subscribe_to_dataset(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   DatasetName = "string",
#'   DeviceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_subscribe_to_dataset
cognitosync_subscribe_to_dataset <- function(IdentityPoolId, IdentityId, DatasetName, DeviceId) {
  op <- new_operation(
    name = "SubscribeToDataset",
    http_method = "POST",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}",
    paginator = list()
  )
  input <- .cognitosync$subscribe_to_dataset_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, DatasetName = DatasetName, DeviceId = DeviceId)
  output <- .cognitosync$subscribe_to_dataset_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$subscribe_to_dataset <- cognitosync_subscribe_to_dataset

#' Unsubscribes from receiving notifications when a dataset is modified by
#' another device
#'
#' @description
#' Unsubscribes from receiving notifications when a dataset is modified by
#' another device.
#' 
#' This API can only be called with temporary credentials provided by
#' Cognito Identity. You cannot call this API with developer credentials.
#'
#' @usage
#' cognitosync_unsubscribe_from_dataset(IdentityPoolId, IdentityId,
#'   DatasetName, DeviceId)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. The ID of the pool to which this identity belongs.
#' @param IdentityId &#91;required&#93; Unique ID for this identity.
#' @param DatasetName &#91;required&#93; The name of the dataset from which to unsubcribe.
#' @param DeviceId &#91;required&#93; The unique ID generated for this device by Cognito.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$unsubscribe_from_dataset(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   DatasetName = "string",
#'   DeviceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_unsubscribe_from_dataset
cognitosync_unsubscribe_from_dataset <- function(IdentityPoolId, IdentityId, DatasetName, DeviceId) {
  op <- new_operation(
    name = "UnsubscribeFromDataset",
    http_method = "DELETE",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}",
    paginator = list()
  )
  input <- .cognitosync$unsubscribe_from_dataset_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, DatasetName = DatasetName, DeviceId = DeviceId)
  output <- .cognitosync$unsubscribe_from_dataset_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$unsubscribe_from_dataset <- cognitosync_unsubscribe_from_dataset

#' Posts updates to records and adds and deletes records for a dataset and
#' user
#'
#' @description
#' Posts updates to records and adds and deletes records for a dataset and
#' user.
#' 
#' The sync count in the record patch is your last known sync count for
#' that record. The server will reject an UpdateRecords request with a
#' ResourceConflictException if you try to patch a record with a new value
#' but a stale sync count.
#' 
#' For example, if the sync count on the server is 5 for a key called
#' highScore and you try and submit a new highScore with sync count of 4,
#' the request will be rejected. To obtain the current sync count for a
#' record, call ListRecords. On a successful update of the record, the
#' response returns the new sync count for that record. You should present
#' that sync count the next time you try to update that same record. When
#' the record does not exist, specify the sync count as 0.
#' 
#' This API can be called with temporary user credentials provided by
#' Cognito Identity or with developer credentials.
#'
#' @usage
#' cognitosync_update_records(IdentityPoolId, IdentityId, DatasetName,
#'   DeviceId, RecordPatches, SyncSessionToken, ClientContext)
#'
#' @param IdentityPoolId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param IdentityId &#91;required&#93; A name-spaced GUID (for example,
#' us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
#' Cognito. GUID generation is unique within a region.
#' @param DatasetName &#91;required&#93; A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9,
#' '_' (underscore), '-' (dash), and '.' (dot).
#' @param DeviceId The unique ID generated for this device by Cognito.
#' @param RecordPatches A list of patch operations.
#' @param SyncSessionToken &#91;required&#93; The SyncSessionToken returned by a previous call to ListRecords for this
#' dataset and identity.
#' @param ClientContext Intended to supply a device ID that will populate the lastModifiedBy
#' field referenced in other methods. The ClientContext field is not yet
#' implemented.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Records = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       SyncCount = 123,
#'       LastModifiedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedBy = "string",
#'       DeviceLastModifiedDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_records(
#'   IdentityPoolId = "string",
#'   IdentityId = "string",
#'   DatasetName = "string",
#'   DeviceId = "string",
#'   RecordPatches = list(
#'     list(
#'       Op = "replace"|"remove",
#'       Key = "string",
#'       Value = "string",
#'       SyncCount = 123,
#'       DeviceLastModifiedDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   SyncSessionToken = "string",
#'   ClientContext = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cognitosync_update_records
cognitosync_update_records <- function(IdentityPoolId, IdentityId, DatasetName, DeviceId = NULL, RecordPatches = NULL, SyncSessionToken, ClientContext = NULL) {
  op <- new_operation(
    name = "UpdateRecords",
    http_method = "POST",
    http_path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
    paginator = list()
  )
  input <- .cognitosync$update_records_input(IdentityPoolId = IdentityPoolId, IdentityId = IdentityId, DatasetName = DatasetName, DeviceId = DeviceId, RecordPatches = RecordPatches, SyncSessionToken = SyncSessionToken, ClientContext = ClientContext)
  output <- .cognitosync$update_records_output()
  config <- get_config()
  svc <- .cognitosync$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitosync$operations$update_records <- cognitosync_update_records
