% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_identity_provider}
\alias{cognitoidentityprovider_create_identity_provider}
\title{Creates an identity provider for a user pool}
\usage{
cognitoidentityprovider_create_identity_provider(UserPoolId,
  ProviderName, ProviderType, ProviderDetails, AttributeMapping,
  IdpIdentifiers)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{ProviderName}{[required] The identity provider name.}

\item{ProviderType}{[required] The identity provider type.}

\item{ProviderDetails}{[required] The identity provider details. The following list describes the provider
detail keys for each identity provider type.
\itemize{
\item For Google and Login with Amazon:
\itemize{
\item client_id
\item client_secret
\item authorize_scopes
}
\item For Facebook:
\itemize{
\item client_id
\item client_secret
\item authorize_scopes
\item api_version
}
\item For Sign in with Apple:
\itemize{
\item client_id
\item team_id
\item key_id
\item private_key
\item authorize_scopes
}
\item For OIDC providers:
\itemize{
\item client_id
\item client_secret
\item attributes_request_method
\item oidc_issuer
\item authorize_scopes
\item authorize_url \emph{if not available from discovery URL specified by
oidc_issuer key}
\item token_url \emph{if not available from discovery URL specified by
oidc_issuer key}
\item attributes_url \emph{if not available from discovery URL specified
by oidc_issuer key}
\item jwks_uri \emph{if not available from discovery URL specified by
oidc_issuer key}
}
\item For SAML providers:
\itemize{
\item MetadataFile OR MetadataURL
\item IDPSignout \emph{optional}
}
}}

\item{AttributeMapping}{A mapping of identity provider attributes to standard and custom user
pool attributes.}

\item{IdpIdentifiers}{A list of identity provider identifiers.}
}
\value{
A list with the following syntax:\preformatted{list(
  IdentityProvider = list(
    UserPoolId = "string",
    ProviderName = "string",
    ProviderType = "SAML"|"Facebook"|"Google"|"LoginWithAmazon"|"SignInWithApple"|"OIDC",
    ProviderDetails = list(
      "string"
    ),
    AttributeMapping = list(
      "string"
    ),
    IdpIdentifiers = list(
      "string"
    ),
    LastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    CreationDate = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Creates an identity provider for a user pool.
}
\section{Request syntax}{
\preformatted{svc$create_identity_provider(
  UserPoolId = "string",
  ProviderName = "string",
  ProviderType = "SAML"|"Facebook"|"Google"|"LoginWithAmazon"|"SignInWithApple"|"OIDC",
  ProviderDetails = list(
    "string"
  ),
  AttributeMapping = list(
    "string"
  ),
  IdpIdentifiers = list(
    "string"
  )
)
}
}

\keyword{internal}
