% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_list_groups}
\alias{cognitoidentityprovider_list_groups}
\title{Lists the groups associated with a user pool}
\usage{
cognitoidentityprovider_list_groups(UserPoolId, Limit, NextToken)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{Limit}{The limit of the request to list groups.}

\item{NextToken}{An identifier that was returned from the previous call to this
operation, which can be used to return the next set of items in the
list.}
}
\value{
A list with the following syntax:\preformatted{list(
  Groups = list(
    list(
      GroupName = "string",
      UserPoolId = "string",
      Description = "string",
      RoleArn = "string",
      Precedence = 123,
      LastModifiedDate = as.POSIXct(
        "2015-01-01"
      ),
      CreationDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the groups associated with a user pool.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$list_groups(
  UserPoolId = "string",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
