% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_cancel_key_deletion}
\alias{kms_cancel_key_deletion}
\title{Cancels the deletion of a customer master key (CMK)}
\usage{
kms_cancel_key_deletion(KeyId)
}
\arguments{
\item{KeyId}{[required] The unique identifier for the customer master key (CMK) for which to
cancel deletion.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  KeyId = "string"
)
}
}
\description{
Cancels the deletion of a customer master key (CMK). When this operation
succeeds, the key state of the CMK is \code{Disabled}. To enable the CMK, use
\code{\link[=kms_enable_key]{enable_key}}.

For more information about scheduling and canceling deletion of a CMK,
see \href{https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html}{Deleting Customer Master Keys}
in the \emph{AWS Key Management Service Developer Guide}.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:CancelKeyDeletion}
(key policy)

\strong{Related operations}:
\code{\link[=kms_schedule_key_deletion]{schedule_key_deletion}}
}
\section{Request syntax}{
\preformatted{svc$cancel_key_deletion(
  KeyId = "string"
)
}
}

\examples{
\dontrun{
# The following example cancels deletion of the specified CMK.
svc$cancel_key_deletion(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
