% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_decrypt}
\alias{kms_decrypt}
\title{Decrypts ciphertext}
\usage{
kms_decrypt(CiphertextBlob, EncryptionContext, GrantTokens)
}
\arguments{
\item{CiphertextBlob}{[required] Ciphertext to be decrypted. The blob includes metadata.}

\item{EncryptionContext}{The encryption context. If this was specified in the Encrypt function,
it must be specified here or the decryption operation will fail. For
more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption Context}.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Decrypts ciphertext. Ciphertext is plaintext that has been previously
encrypted by using any of the following operations:
}
\details{
\itemize{
\item GenerateDataKey
\item GenerateDataKeyWithoutPlaintext
\item Encrypt
}

Whenever possible, use key policies to give users permission to call the
Decrypt operation on the CMK, instead of IAM policies. Otherwise, you
might create an IAM user policy that gives the user Decrypt permission
on all CMKs. This user could decrypt ciphertext that was encrypted by
CMKs in other accounts if the key policy for the cross-account CMK
permits it. If you must use an IAM policy for \code{Decrypt} permissions,
limit the user to particular CMKs or particular trusted accounts.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$decrypt(
  CiphertextBlob = raw,
  EncryptionContext = list(
    "string"
  ),
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
# The following example decrypts data that was encrypted with a customer
# master key (CMK) in AWS KMS.
\donttest{svc$decrypt(
  CiphertextBlob = "<binary data>"
)}

}
\keyword{internal}
