% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_encrypt}
\alias{kms_encrypt}
\title{Encrypts plaintext into ciphertext by using a customer master key (CMK)}
\usage{
kms_encrypt(KeyId, Plaintext, EncryptionContext, GrantTokens)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{Plaintext}{[required] Data to be encrypted.}

\item{EncryptionContext}{Name-value pair that specifies the encryption context to be used for
authenticated encryption. If used here, the same value must be supplied
to the \code{Decrypt} API or decryption will fail. For more information, see
\href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption Context}.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Encrypts plaintext into ciphertext by using a customer master key (CMK).
The \code{Encrypt} operation has two primary use cases:
}
\details{
\itemize{
\item You can encrypt up to 4 kilobytes (4096 bytes) of arbitrary data
such as an RSA key, a database password, or other sensitive
information.
\item You can use the \code{Encrypt} operation to move encrypted data from one
AWS region to another. In the first region, generate a data key and
use the plaintext key to encrypt the data. Then, in the new region,
call the \code{Encrypt} method on same plaintext data key. Now, you can
safely move the encrypted data and encrypted data key to the new
region, and decrypt in the new region when necessary.
}

You don't need use this operation to encrypt a data key within a
region. The GenerateDataKey and GenerateDataKeyWithoutPlaintext
operations return an encrypted data key.

Also, you don't need to use this operation to encrypt data in your
application. You can use the plaintext and encrypted data keys that the
\code{GenerateDataKey} operation returns.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

To perform this operation on a CMK in a different AWS account, specify
the key ARN or alias ARN in the value of the KeyId parameter.
}
\section{Request syntax}{
\preformatted{svc$encrypt(
  KeyId = "string",
  Plaintext = raw,
  EncryptionContext = list(
    "string"
  ),
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
# The following example encrypts data with the specified customer master
# key (CMK).
\donttest{svc$encrypt(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  Plaintext = "<binary data>"
)}

}
\keyword{internal}
