% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_untag_resource}
\alias{kms_untag_resource}
\title{Removes the specified tags from the specified customer master key (CMK)}
\usage{
kms_untag_resource(KeyId, TagKeys)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the CMK from which you are removing tags.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{TagKeys}{[required] One or more tag keys. Specify only the tag keys, not the tag values.}
}
\description{
Removes the specified tags from the specified customer master key (CMK).
You cannot perform this operation on a CMK in a different AWS account.
}
\details{
To remove a tag, specify the tag key. To change the tag value of an
existing tag key, use TagResource.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  KeyId = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
# The following example removes tags from a CMK.
\donttest{svc$untag_resource(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  TagKeys = list(
    "Purpose",
    "CostCenter"
  )
)}

}
\keyword{internal}
