% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_associate_admin_account}
\alias{fms_associate_admin_account}
\title{Sets the AWS Firewall Manager administrator account}
\usage{
fms_associate_admin_account(AdminAccount)
}
\arguments{
\item{AdminAccount}{[required] The AWS account ID to associate with AWS Firewall Manager as the AWS
Firewall Manager administrator account. This can be an AWS Organizations
master account or a member account. For more information about AWS
Organizations and master accounts, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html}{Managing the AWS Accounts in Your Organization}.}
}
\description{
Sets the AWS Firewall Manager administrator account. AWS Firewall
Manager must be associated with the master account your AWS organization
or associated with a member account that has the appropriate
permissions. If the account ID that you submit is not an AWS
Organizations master account, AWS Firewall Manager will set the
appropriate permissions for the given member account.
}
\details{
The account that you associate with AWS Firewall Manager is called the
AWS Firewall Manager administrator account.
}
\section{Request syntax}{
\preformatted{svc$associate_admin_account(
  AdminAccount = "string"
)
}
}

\keyword{internal}
