% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_ip_set}
\alias{wafregional_update_ip_set}
\title{Inserts or deletes IPSetDescriptor objects in an IPSet}
\usage{
wafregional_update_ip_set(IPSetId, ChangeToken, Updates)
}
\arguments{
\item{IPSetId}{[required] The \code{IPSetId} of the IPSet that you want to update. \code{IPSetId} is
returned by CreateIPSet and by ListIPSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Updates}{[required] An array of \code{IPSetUpdate} objects that you want to insert into or delete
from an IPSet. For more information, see the applicable data types:
\itemize{
\item IPSetUpdate: Contains \code{Action} and \code{IPSetDescriptor}
\item IPSetDescriptor: Contains \code{Type} and \code{Value}
}

You can insert a maximum of 1000 addresses in a single request.}
}
\description{
Inserts or deletes IPSetDescriptor objects in an \code{IPSet}. For each
\code{IPSetDescriptor} object, you specify the following values:
}
\details{
\itemize{
\item Whether to insert or delete the object from the array. If you want
to change an \code{IPSetDescriptor} object, you delete the existing
object and add a new one.
\item The IP address version, \code{IPv4} or \code{IPv6}.
\item The IP address in CIDR notation, for example, \verb{192.0.2.0/24} (for
the range of IP addresses from \verb{192.0.2.0} to \verb{192.0.2.255}) or
\verb{192.0.2.44/32} (for the individual IP address \verb{192.0.2.44}).
}

AWS WAF supports IPv4 address ranges: /8 and any range between /16
through /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56,
/64, and /128. For more information about CIDR notation, see the
Wikipedia entry \href{https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing}{Classless Inter-Domain Routing}.

IPv6 addresses can be represented using any of the following formats:
\itemize{
\item 1111:0000:0000:0000:0000:0000:0000:0111/128
\item 1111:0:0:0:0:0:0:0111/128
\item 1111::0111/128
\item 1111::111/128
}

You use an \code{IPSet} to specify which web requests you want to allow or
block based on the IP addresses that the requests originated from. For
example, if you\'re receiving a lot of requests from one or a small
number of IP addresses and you want to block the requests, you can
create an \code{IPSet} that specifies those IP addresses, and then configure
AWS WAF to block the requests.

To create and configure an \code{IPSet}, perform the following steps:
\enumerate{
\item Submit a CreateIPSet request.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateIPSet request.
\item Submit an \code{UpdateIPSet} request to specify the IP addresses that you
want AWS WAF to watch for.
}

When you update an \code{IPSet}, you specify the IP addresses that you want
to add and/or the IP addresses that you want to delete. If you want to
change an IP address, you delete the existing IP address and add the new
one.

You can insert a maximum of 1000 addresses in a single request.

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_ip_set(
  IPSetId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      IPSetDescriptor = list(
        Type = "IPV4"|"IPV6",
        Value = "string"
      )
    )
  )
)
}
}

\examples{
# The following example deletes an IPSetDescriptor object in an IP match
# set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
\donttest{svc$update_ip_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  IPSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5",
  Updates = list(
    list(
      Action = "DELETE",
      IPSetDescriptor = list(
        Type = "IPV4",
        Value = "192.0.2.44/32"
      )
    )
  )
)}

}
\keyword{internal}
