% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_delete_ip_set}
\alias{waf_delete_ip_set}
\title{Permanently deletes an IPSet}
\usage{
waf_delete_ip_set(IPSetId, ChangeToken)
}
\arguments{
\item{IPSetId}{[required] The \code{IPSetId} of the IPSet that you want to delete. \code{IPSetId} is
returned by CreateIPSet and by ListIPSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Permanently deletes an IPSet. You can\'t delete an \code{IPSet} if it\'s
still used in any \code{Rules} or if it still includes any IP addresses.
}
\details{
If you just want to remove an \code{IPSet} from a \code{Rule}, use UpdateRule.

To permanently delete an \code{IPSet} from AWS WAF, perform the following
steps:
\enumerate{
\item Update the \code{IPSet} to remove IP address ranges, if any. For more
information, see UpdateIPSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteIPSet} request.
\item Submit a \code{DeleteIPSet} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_ip_set(
  IPSetId = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes an IP match set  with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
svc$delete_ip_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  IPSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)
}

}
\keyword{internal}
