% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_list_web_ac_ls}
\alias{wafregional_list_web_ac_ls}
\title{Returns an array of WebACLSummary objects in the response}
\usage{
wafregional_list_web_ac_ls(NextMarker, Limit)
}
\arguments{
\item{NextMarker}{If you specify a value for \code{Limit} and you have more \code{WebACL} objects
than the number that you specify for \code{Limit}, AWS WAF returns a
\code{NextMarker} value in the response that allows you to list another group
of \code{WebACL} objects. For the second and subsequent \code{ListWebACLs}
requests, specify the value of \code{NextMarker} from the previous response
to get information about another batch of \code{WebACL} objects.}

\item{Limit}{Specifies the number of \code{WebACL} objects that you want AWS WAF to return
for this request. If you have more \code{WebACL} objects than the number that
you specify for \code{Limit}, the response includes a \code{NextMarker} value that
you can use to get another batch of \code{WebACL} objects.}
}
\description{
Returns an array of WebACLSummary objects in the response.
}
\section{Request syntax}{
\preformatted{svc$list_web_ac_ls(
  NextMarker = "string",
  Limit = 123
)
}
}

\examples{
\dontrun{
# The following example returns an array of up to 100 web ACLs.
svc$list_web_ac_ls(
  Limit = 100L
)
}

}
\keyword{internal}
