% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_sql_injection_match_set}
\alias{wafregional_update_sql_injection_match_set}
\title{Inserts or deletes SqlInjectionMatchTuple objects (filters) in a
SqlInjectionMatchSet}
\usage{
wafregional_update_sql_injection_match_set(SqlInjectionMatchSetId,
  ChangeToken, Updates)
}
\arguments{
\item{SqlInjectionMatchSetId}{[required] The \code{SqlInjectionMatchSetId} of the \code{SqlInjectionMatchSet} that you want
to update. \code{SqlInjectionMatchSetId} is returned by
CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Updates}{[required] An array of \code{SqlInjectionMatchSetUpdate} objects that you want to insert
into or delete from a SqlInjectionMatchSet. For more information, see
the applicable data types:
\itemize{
\item SqlInjectionMatchSetUpdate: Contains \code{Action} and
\code{SqlInjectionMatchTuple}
\item SqlInjectionMatchTuple: Contains \code{FieldToMatch} and
\code{TextTransformation}
\item FieldToMatch: Contains \code{Data} and \code{Type}
}}
}
\description{
Inserts or deletes SqlInjectionMatchTuple objects (filters) in a
SqlInjectionMatchSet. For each \code{SqlInjectionMatchTuple} object, you
specify the following values:
}
\details{
\itemize{
\item \code{Action}: Whether to insert the object into or delete the object
from the array. To change a \code{SqlInjectionMatchTuple}, you delete the
existing object and add a new one.
\item \code{FieldToMatch}: The part of web requests that you want AWS WAF to
inspect and, if you want AWS WAF to inspect a header or custom query
parameter, the name of the header or parameter.
\item \code{TextTransformation}: Which text transformation, if any, to perform
on the web request before inspecting the request for snippets of
malicious SQL code.

You can only specify a single type of TextTransformation.
}

You use \code{SqlInjectionMatchSet} objects to specify which CloudFront
requests that you want to allow, block, or count. For example, if
you\'re receiving requests that contain snippets of SQL code in the
query string and you want to block the requests, you can create a
\code{SqlInjectionMatchSet} with the applicable settings, and then configure
AWS WAF to block the requests.

To create and configure a \code{SqlInjectionMatchSet}, perform the following
steps:
\enumerate{
\item Submit a CreateSqlInjectionMatchSet request.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateIPSet request.
\item Submit an \code{UpdateSqlInjectionMatchSet} request to specify the parts
of web requests that you want AWS WAF to inspect for snippets of SQL
code.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_sql_injection_match_set(
  SqlInjectionMatchSetId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      SqlInjectionMatchTuple = list(
        FieldToMatch = list(
          Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
          Data = "string"
        ),
        TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
      )
    )
  )
)
}
}

\examples{
\dontrun{
# The following example deletes a SqlInjectionMatchTuple object (filters)
# in a SQL injection match set with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
svc$update_sql_injection_match_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  SqlInjectionMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5",
  Updates = list(
    list(
      Action = "DELETE",
      SqlInjectionMatchTuple = list(
        FieldToMatch = list(
          Type = "QUERY_STRING"
        ),
        TextTransformation = "URL_DECODE"
      )
    )
  )
)
}

}
\keyword{internal}
