# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include guardduty_service.R
NULL

#' Accepts the invitation to be monitored by a master GuardDuty account
#'
#' Accepts the invitation to be monitored by a master GuardDuty account.
#'
#' @usage
#' guardduty_accept_invitation(DetectorId, MasterId, InvitationId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' @param MasterId &#91;required&#93; The account ID of the master GuardDuty account whose invitation you\'re
#' accepting.
#' @param InvitationId &#91;required&#93; The value that is used to validate the master account to the member
#' account.
#'
#' @section Request syntax:
#' ```
#' svc$accept_invitation(
#'   DetectorId = "string",
#'   MasterId = "string",
#'   InvitationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_accept_invitation
guardduty_accept_invitation <- function(DetectorId, MasterId, InvitationId) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master",
    paginator = list()
  )
  input <- .guardduty$accept_invitation_input(DetectorId = DetectorId, MasterId = MasterId, InvitationId = InvitationId)
  output <- .guardduty$accept_invitation_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$accept_invitation <- guardduty_accept_invitation

#' Archives GuardDuty findings that are specified by the list of finding
#' IDs
#'
#' Archives GuardDuty findings that are specified by the list of finding
#' IDs.
#' 
#' Only the master account can archive findings. Member accounts don\'t
#' have permission to archive findings from their accounts.
#'
#' @usage
#' guardduty_archive_findings(DetectorId, FindingIds)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to archive.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to archive.
#'
#' @section Request syntax:
#' ```
#' svc$archive_findings(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_archive_findings
guardduty_archive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "ArchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/archive",
    paginator = list()
  )
  input <- .guardduty$archive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$archive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$archive_findings <- guardduty_archive_findings

#' Creates a single Amazon GuardDuty detector
#'
#' Creates a single Amazon GuardDuty detector. A detector is a resource
#' that represents the GuardDuty service. To start using GuardDuty, you
#' must create a detector in each Region where you enable the service. You
#' can have only one detector per account per Region.
#'
#' @usage
#' guardduty_create_detector(Enable, ClientToken,
#'   FindingPublishingFrequency, Tags)
#'
#' @param Enable &#91;required&#93; A Boolean value that specifies whether the detector is to be enabled.
#' @param ClientToken The idempotency token for the create request.
#' @param FindingPublishingFrequency An enum value that specifies how frequently updated findings are
#' exported.
#' @param Tags The tags to be added to a new detector resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_detector(
#'   Enable = TRUE|FALSE,
#'   ClientToken = "string",
#'   FindingPublishingFrequency = "FIFTEEN_MINUTES"|"ONE_HOUR"|"SIX_HOURS",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_detector
guardduty_create_detector <- function(Enable, ClientToken = NULL, FindingPublishingFrequency = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDetector",
    http_method = "POST",
    http_path = "/detector",
    paginator = list()
  )
  input <- .guardduty$create_detector_input(Enable = Enable, ClientToken = ClientToken, FindingPublishingFrequency = FindingPublishingFrequency, Tags = Tags)
  output <- .guardduty$create_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_detector <- guardduty_create_detector

#' Creates a filter using the specified finding criteria
#'
#' Creates a filter using the specified finding criteria.
#'
#' @usage
#' guardduty_create_filter(DetectorId, Name, Description, Action, Rank,
#'   FindingCriteria, ClientToken, Tags)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' create a filter for.
#' @param Name &#91;required&#93; The name of the filter.
#' @param Description The description of the filter.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria &#91;required&#93; Represents the criteria to be used in the filter for querying findings.
#' 
#' You can only use the following attributes to query findings:
#' 
#' -   accountId
#' 
#' -   region
#' 
#' -   confidence
#' 
#' -   id
#' 
#' -   resource.accessKeyDetails.accessKeyId
#' 
#' -   resource.accessKeyDetails.principalId
#' 
#' -   resource.accessKeyDetails.userName
#' 
#' -   resource.accessKeyDetails.userType
#' 
#' -   resource.instanceDetails.iamInstanceProfile.id
#' 
#' -   resource.instanceDetails.imageId
#' 
#' -   resource.instanceDetails.instanceId
#' 
#' -   resource.instanceDetails.outpostArn
#' 
#' -   resource.instanceDetails.networkInterfaces.ipv6Addresses
#' 
#' -   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
#' 
#' -   resource.instanceDetails.networkInterfaces.publicDnsName
#' 
#' -   resource.instanceDetails.networkInterfaces.publicIp
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupId
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupName
#' 
#' -   resource.instanceDetails.networkInterfaces.subnetId
#' 
#' -   resource.instanceDetails.networkInterfaces.vpcId
#' 
#' -   resource.instanceDetails.tags.key
#' 
#' -   resource.instanceDetails.tags.value
#' 
#' -   resource.resourceType
#' 
#' -   service.action.actionType
#' 
#' -   service.action.awsApiCallAction.api
#' 
#' -   service.action.awsApiCallAction.callerType
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.awsApiCallAction.serviceName
#' 
#' -   service.action.dnsRequestAction.domain
#' 
#' -   service.action.networkConnectionAction.blocked
#' 
#' -   service.action.networkConnectionAction.connectionDirection
#' 
#' -   service.action.networkConnectionAction.localPortDetails.port
#' 
#' -   service.action.networkConnectionAction.protocol
#' 
#' -   service.action.networkConnectionAction.localIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.networkConnectionAction.remotePortDetails.port
#' 
#' -   service.additionalInfo.threatListName
#' 
#' -   service.archived
#' 
#'     When this attribute is set to TRUE, only archived findings are
#'     listed. When it\'s set to FALSE, only unarchived findings are
#'     listed. When this attribute is not set, all existing findings are
#'     listed.
#' 
#' -   service.resourceRole
#' 
#' -   severity
#' 
#' -   type
#' 
#' -   updatedAt
#' 
#'     Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or
#'     YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains
#'     milliseconds.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new filter resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_filter(
#'   DetectorId = "string",
#'   Name = "string",
#'   Description = "string",
#'   Action = "NOOP"|"ARCHIVE",
#'   Rank = 123,
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   ),
#'   ClientToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_filter
guardduty_create_filter <- function(DetectorId, Name, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter",
    paginator = list()
  )
  input <- .guardduty$create_filter_input(DetectorId = DetectorId, Name = Name, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_filter <- guardduty_create_filter

#' Creates a new IPSet, which is called a trusted IP list in the console
#' user interface
#'
#' Creates a new IPSet, which is called a trusted IP list in the console
#' user interface. An IPSet is a list of IP addresses that are trusted for
#' secure communication with AWS infrastructure and applications. GuardDuty
#' doesn\'t generate findings for IP addresses that are included in IPSets.
#' Only users from the master account can use this operation.
#'
#' @usage
#' guardduty_create_ip_set(DetectorId, Name, Format, Location, Activate,
#'   ClientToken, Tags)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' create an IPSet for.
#' @param Name &#91;required&#93; The user-friendly name to identify the IPSet.
#' 
#' Allowed characters are alphanumerics, spaces, hyphens (-), and
#' underscores (\\_).
#' @param Format &#91;required&#93; The format of the file that contains the IPSet.
#' @param Location &#91;required&#93; The URI of the file that contains the IPSet. For example:
#' https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
#' @param Activate &#91;required&#93; A Boolean value that indicates whether GuardDuty is to start using the
#' uploaded IPSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new IP set resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_ip_set(
#'   DetectorId = "string",
#'   Name = "string",
#'   Format = "TXT"|"STIX"|"OTX_CSV"|"ALIEN_VAULT"|"PROOF_POINT"|"FIRE_EYE",
#'   Location = "string",
#'   Activate = TRUE|FALSE,
#'   ClientToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_ip_set
guardduty_create_ip_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset",
    paginator = list()
  )
  input <- .guardduty$create_ip_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_ip_set <- guardduty_create_ip_set

#' Creates member accounts of the current AWS account by specifying a list
#' of AWS account IDs
#'
#' Creates member accounts of the current AWS account by specifying a list
#' of AWS account IDs. The current AWS account can then invite these
#' members to manage GuardDuty in their accounts.
#'
#' @usage
#' guardduty_create_members(DetectorId, AccountDetails)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' associate member accounts with.
#' @param AccountDetails &#91;required&#93; A list of account ID and email address pairs of the accounts that you
#' want to associate with the master GuardDuty account.
#'
#' @section Request syntax:
#' ```
#' svc$create_members(
#'   DetectorId = "string",
#'   AccountDetails = list(
#'     list(
#'       AccountId = "string",
#'       Email = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_members
guardduty_create_members <- function(DetectorId, AccountDetails) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member",
    paginator = list()
  )
  input <- .guardduty$create_members_input(DetectorId = DetectorId, AccountDetails = AccountDetails)
  output <- .guardduty$create_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_members <- guardduty_create_members

#' Creates a publishing destination to export findings to
#'
#' Creates a publishing destination to export findings to. The resource to
#' export findings to must exist before you use this operation.
#'
#' @usage
#' guardduty_create_publishing_destination(DetectorId, DestinationType,
#'   DestinationProperties, ClientToken)
#'
#' @param DetectorId &#91;required&#93; The ID of the GuardDuty detector associated with the publishing
#' destination.
#' @param DestinationType &#91;required&#93; The type of resource for the publishing destination. Currently only
#' Amazon S3 buckets are supported.
#' @param DestinationProperties &#91;required&#93; The properties of the publishing destination, including the ARNs for the
#' destination and the KMS key used for encryption.
#' @param ClientToken The idempotency token for the request.
#'
#' @section Request syntax:
#' ```
#' svc$create_publishing_destination(
#'   DetectorId = "string",
#'   DestinationType = "S3",
#'   DestinationProperties = list(
#'     DestinationArn = "string",
#'     KmsKeyArn = "string"
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_publishing_destination
guardduty_create_publishing_destination <- function(DetectorId, DestinationType, DestinationProperties, ClientToken = NULL) {
  op <- new_operation(
    name = "CreatePublishingDestination",
    http_method = "POST",
    http_path = "/detector/{detectorId}/publishingDestination",
    paginator = list()
  )
  input <- .guardduty$create_publishing_destination_input(DetectorId = DetectorId, DestinationType = DestinationType, DestinationProperties = DestinationProperties, ClientToken = ClientToken)
  output <- .guardduty$create_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_publishing_destination <- guardduty_create_publishing_destination

#' Generates example findings of types specified by the list of finding
#' types
#'
#' Generates example findings of types specified by the list of finding
#' types. If \'NULL\' is specified for `findingTypes`, the API generates
#' example findings of all supported finding types.
#'
#' @usage
#' guardduty_create_sample_findings(DetectorId, FindingTypes)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to create sample findings for.
#' @param FindingTypes The types of sample findings to generate.
#'
#' @section Request syntax:
#' ```
#' svc$create_sample_findings(
#'   DetectorId = "string",
#'   FindingTypes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_sample_findings
guardduty_create_sample_findings <- function(DetectorId, FindingTypes = NULL) {
  op <- new_operation(
    name = "CreateSampleFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/create",
    paginator = list()
  )
  input <- .guardduty$create_sample_findings_input(DetectorId = DetectorId, FindingTypes = FindingTypes)
  output <- .guardduty$create_sample_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_sample_findings <- guardduty_create_sample_findings

#' Creates a new ThreatIntelSet
#'
#' Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious
#' IP addresses. GuardDuty generates findings based on ThreatIntelSets.
#' Only users of the master account can use this operation.
#'
#' @usage
#' guardduty_create_threat_intel_set(DetectorId, Name, Format, Location,
#'   Activate, ClientToken, Tags)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' create a threatIntelSet for.
#' @param Name &#91;required&#93; A user-friendly ThreatIntelSet name displayed in all findings that are
#' generated by activity that involves IP addresses included in this
#' ThreatIntelSet.
#' @param Format &#91;required&#93; The format of the file that contains the ThreatIntelSet.
#' @param Location &#91;required&#93; The URI of the file that contains the ThreatIntelSet. For example:
#' https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
#' @param Activate &#91;required&#93; A Boolean value that indicates whether GuardDuty is to start using the
#' uploaded ThreatIntelSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new threat list resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_threat_intel_set(
#'   DetectorId = "string",
#'   Name = "string",
#'   Format = "TXT"|"STIX"|"OTX_CSV"|"ALIEN_VAULT"|"PROOF_POINT"|"FIRE_EYE",
#'   Location = "string",
#'   Activate = TRUE|FALSE,
#'   ClientToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_threat_intel_set
guardduty_create_threat_intel_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset",
    paginator = list()
  )
  input <- .guardduty$create_threat_intel_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_threat_intel_set <- guardduty_create_threat_intel_set

#' Declines invitations sent to the current member account by AWS accounts
#' specified by their account IDs
#'
#' Declines invitations sent to the current member account by AWS accounts
#' specified by their account IDs.
#'
#' @usage
#' guardduty_decline_invitations(AccountIds)
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the AWS accounts that sent invitations to the
#' current member account that you want to decline invitations from.
#'
#' @section Request syntax:
#' ```
#' svc$decline_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_decline_invitations
guardduty_decline_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitation/decline",
    paginator = list()
  )
  input <- .guardduty$decline_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$decline_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$decline_invitations <- guardduty_decline_invitations

#' Deletes an Amazon GuardDuty detector that is specified by the detector
#' ID
#'
#' Deletes an Amazon GuardDuty detector that is specified by the detector
#' ID.
#'
#' @usage
#' guardduty_delete_detector(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_detector(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_detector
guardduty_delete_detector <- function(DetectorId) {
  op <- new_operation(
    name = "DeleteDetector",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$delete_detector_input(DetectorId = DetectorId)
  output <- .guardduty$delete_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_detector <- guardduty_delete_detector

#' Deletes the filter specified by the filter name
#'
#' Deletes the filter specified by the filter name.
#'
#' @usage
#' guardduty_delete_filter(DetectorId, FilterName)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the filter is associated with.
#' @param FilterName &#91;required&#93; The name of the filter that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_filter(
#'   DetectorId = "string",
#'   FilterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_filter
guardduty_delete_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$delete_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$delete_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_filter <- guardduty_delete_filter

#' Deletes the IPSet specified by the ipSetId
#'
#' Deletes the IPSet specified by the `ipSetId`. IPSets are called trusted
#' IP lists in the console user interface.
#'
#' @usage
#' guardduty_delete_ip_set(DetectorId, IpSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the IPSet.
#' @param IpSetId &#91;required&#93; The unique ID of the IPSet to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_ip_set(
#'   DetectorId = "string",
#'   IpSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_ip_set
guardduty_delete_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "DeleteIPSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$delete_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$delete_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_ip_set <- guardduty_delete_ip_set

#' Deletes invitations sent to the current member account by AWS accounts
#' specified by their account IDs
#'
#' Deletes invitations sent to the current member account by AWS accounts
#' specified by their account IDs.
#'
#' @usage
#' guardduty_delete_invitations(AccountIds)
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the AWS accounts that sent invitations to the
#' current member account that you want to delete invitations from.
#'
#' @section Request syntax:
#' ```
#' svc$delete_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_invitations
guardduty_delete_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitation/delete",
    paginator = list()
  )
  input <- .guardduty$delete_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$delete_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_invitations <- guardduty_delete_invitations

#' Deletes GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs
#'
#' Deletes GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs.
#'
#' @usage
#' guardduty_delete_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to delete.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_members
guardduty_delete_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/delete",
    paginator = list()
  )
  input <- .guardduty$delete_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$delete_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_members <- guardduty_delete_members

#' Deletes the publishing definition with the specified destinationId
#'
#' Deletes the publishing definition with the specified `destinationId`.
#'
#' @usage
#' guardduty_delete_publishing_destination(DetectorId, DestinationId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the publishing destination
#' to delete.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_publishing_destination(
#'   DetectorId = "string",
#'   DestinationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_publishing_destination
guardduty_delete_publishing_destination <- function(DetectorId, DestinationId) {
  op <- new_operation(
    name = "DeletePublishingDestination",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    paginator = list()
  )
  input <- .guardduty$delete_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId)
  output <- .guardduty$delete_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_publishing_destination <- guardduty_delete_publishing_destination

#' Deletes the ThreatIntelSet specified by the ThreatIntelSet ID
#'
#' Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
#'
#' @usage
#' guardduty_delete_threat_intel_set(DetectorId, ThreatIntelSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the threatIntelSet is associated
#' with.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_threat_intel_set(
#'   DetectorId = "string",
#'   ThreatIntelSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_threat_intel_set
guardduty_delete_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "DeleteThreatIntelSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$delete_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$delete_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_threat_intel_set <- guardduty_delete_threat_intel_set

#' Returns information about the account selected as the delegated
#' administrator for GuardDuty
#'
#' Returns information about the account selected as the delegated
#' administrator for GuardDuty.
#'
#' @usage
#' guardduty_describe_organization_configuration(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to retrieve information about the delegated
#' administrator from.
#'
#' @section Request syntax:
#' ```
#' svc$describe_organization_configuration(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_organization_configuration
guardduty_describe_organization_configuration <- function(DetectorId) {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "GET",
    http_path = "/detector/{detectorId}/admin",
    paginator = list()
  )
  input <- .guardduty$describe_organization_configuration_input(DetectorId = DetectorId)
  output <- .guardduty$describe_organization_configuration_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_organization_configuration <- guardduty_describe_organization_configuration

#' Returns information about the publishing destination specified by the
#' provided destinationId
#'
#' Returns information about the publishing destination specified by the
#' provided `destinationId`.
#'
#' @usage
#' guardduty_describe_publishing_destination(DetectorId, DestinationId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the publishing destination
#' to retrieve.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_publishing_destination(
#'   DetectorId = "string",
#'   DestinationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_publishing_destination
guardduty_describe_publishing_destination <- function(DetectorId, DestinationId) {
  op <- new_operation(
    name = "DescribePublishingDestination",
    http_method = "GET",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    paginator = list()
  )
  input <- .guardduty$describe_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId)
  output <- .guardduty$describe_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_publishing_destination <- guardduty_describe_publishing_destination

#' Disables an AWS account within the Organization as the GuardDuty
#' delegated administrator
#'
#' Disables an AWS account within the Organization as the GuardDuty
#' delegated administrator.
#'
#' @usage
#' guardduty_disable_organization_admin_account(AdminAccountId)
#'
#' @param AdminAccountId &#91;required&#93; The AWS Account ID for the organizations account to be disabled as a
#' GuardDuty delegated administrator.
#'
#' @section Request syntax:
#' ```
#' svc$disable_organization_admin_account(
#'   AdminAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_disable_organization_admin_account
guardduty_disable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "DisableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/admin/disable",
    paginator = list()
  )
  input <- .guardduty$disable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .guardduty$disable_organization_admin_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disable_organization_admin_account <- guardduty_disable_organization_admin_account

#' Disassociates the current GuardDuty member account from its master
#' account
#'
#' Disassociates the current GuardDuty member account from its master
#' account.
#'
#' @usage
#' guardduty_disassociate_from_master_account(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_from_master_account(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_from_master_account
guardduty_disassociate_from_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master/disassociate",
    paginator = list()
  )
  input <- .guardduty$disassociate_from_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$disassociate_from_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_from_master_account <- guardduty_disassociate_from_master_account

#' Disassociates GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs
#'
#' Disassociates GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs.
#'
#' @usage
#' guardduty_disassociate_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to disassociate from the master account.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' disassociate from the master account.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_members
guardduty_disassociate_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DisassociateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/disassociate",
    paginator = list()
  )
  input <- .guardduty$disassociate_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$disassociate_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_members <- guardduty_disassociate_members

#' Enables an AWS account within the organization as the GuardDuty
#' delegated administrator
#'
#' Enables an AWS account within the organization as the GuardDuty
#' delegated administrator.
#'
#' @usage
#' guardduty_enable_organization_admin_account(AdminAccountId)
#'
#' @param AdminAccountId &#91;required&#93; The AWS Account ID for the organization account to be enabled as a
#' GuardDuty delegated administrator.
#'
#' @section Request syntax:
#' ```
#' svc$enable_organization_admin_account(
#'   AdminAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_enable_organization_admin_account
guardduty_enable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "EnableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/admin/enable",
    paginator = list()
  )
  input <- .guardduty$enable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .guardduty$enable_organization_admin_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$enable_organization_admin_account <- guardduty_enable_organization_admin_account

#' Retrieves an Amazon GuardDuty detector specified by the detectorId
#'
#' Retrieves an Amazon GuardDuty detector specified by the detectorId.
#'
#' @usage
#' guardduty_get_detector(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_detector(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_detector
guardduty_get_detector <- function(DetectorId) {
  op <- new_operation(
    name = "GetDetector",
    http_method = "GET",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$get_detector_input(DetectorId = DetectorId)
  output <- .guardduty$get_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_detector <- guardduty_get_detector

#' Returns the details of the filter specified by the filter name
#'
#' Returns the details of the filter specified by the filter name.
#'
#' @usage
#' guardduty_get_filter(DetectorId, FilterName)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the filter is associated with.
#' @param FilterName &#91;required&#93; The name of the filter you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_filter(
#'   DetectorId = "string",
#'   FilterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_filter
guardduty_get_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "GetFilter",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$get_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$get_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_filter <- guardduty_get_filter

#' Describes Amazon GuardDuty findings specified by finding IDs
#'
#' Describes Amazon GuardDuty findings specified by finding IDs.
#'
#' @usage
#' guardduty_get_findings(DetectorId, FindingIds, SortCriteria)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to retrieve.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to retrieve.
#' @param SortCriteria Represents the criteria used for sorting findings.
#'
#' @section Request syntax:
#' ```
#' svc$get_findings(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   ),
#'   SortCriteria = list(
#'     AttributeName = "string",
#'     OrderBy = "ASC"|"DESC"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings
guardduty_get_findings <- function(DetectorId, FindingIds, SortCriteria = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/get",
    paginator = list()
  )
  input <- .guardduty$get_findings_input(DetectorId = DetectorId, FindingIds = FindingIds, SortCriteria = SortCriteria)
  output <- .guardduty$get_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings <- guardduty_get_findings

#' Lists Amazon GuardDuty findings statistics for the specified detector ID
#'
#' Lists Amazon GuardDuty findings statistics for the specified detector
#' ID.
#'
#' @usage
#' guardduty_get_findings_statistics(DetectorId, FindingStatisticTypes,
#'   FindingCriteria)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings\' statistics you want to retrieve.
#' @param FindingStatisticTypes &#91;required&#93; The types of finding statistics to retrieve.
#' @param FindingCriteria Represents the criteria that is used for querying findings.
#'
#' @section Request syntax:
#' ```
#' svc$get_findings_statistics(
#'   DetectorId = "string",
#'   FindingStatisticTypes = list(
#'     "COUNT_BY_SEVERITY"
#'   ),
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings_statistics
guardduty_get_findings_statistics <- function(DetectorId, FindingStatisticTypes, FindingCriteria = NULL) {
  op <- new_operation(
    name = "GetFindingsStatistics",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/statistics",
    paginator = list()
  )
  input <- .guardduty$get_findings_statistics_input(DetectorId = DetectorId, FindingStatisticTypes = FindingStatisticTypes, FindingCriteria = FindingCriteria)
  output <- .guardduty$get_findings_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings_statistics <- guardduty_get_findings_statistics

#' Retrieves the IPSet specified by the ipSetId
#'
#' Retrieves the IPSet specified by the `ipSetId`.
#'
#' @usage
#' guardduty_get_ip_set(DetectorId, IpSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the IPSet is associated with.
#' @param IpSetId &#91;required&#93; The unique ID of the IPSet to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_ip_set(
#'   DetectorId = "string",
#'   IpSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_ip_set
guardduty_get_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "GetIPSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$get_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$get_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_ip_set <- guardduty_get_ip_set

#' Returns the count of all GuardDuty membership invitations that were sent
#' to the current member account except the currently accepted invitation
#'
#' Returns the count of all GuardDuty membership invitations that were sent
#' to the current member account except the currently accepted invitation.
#'
#' @usage
#' guardduty_get_invitations_count()
#'
#' @section Request syntax:
#' ```
#' svc$get_invitations_count()
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_invitations_count
guardduty_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitation/count",
    paginator = list()
  )
  input <- .guardduty$get_invitations_count_input()
  output <- .guardduty$get_invitations_count_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_invitations_count <- guardduty_get_invitations_count

#' Provides the details for the GuardDuty master account associated with
#' the current GuardDuty member account
#'
#' Provides the details for the GuardDuty master account associated with
#' the current GuardDuty member account.
#'
#' @usage
#' guardduty_get_master_account(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @section Request syntax:
#' ```
#' svc$get_master_account(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_master_account
guardduty_get_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/detector/{detectorId}/master",
    paginator = list()
  )
  input <- .guardduty$get_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$get_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_master_account <- guardduty_get_master_account

#' Retrieves GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs
#'
#' Retrieves GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs.
#'
#' @usage
#' guardduty_get_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to retrieve.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' describe.
#'
#' @section Request syntax:
#' ```
#' svc$get_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_members
guardduty_get_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/get",
    paginator = list()
  )
  input <- .guardduty$get_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_members <- guardduty_get_members

#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID
#'
#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
#'
#' @usage
#' guardduty_get_threat_intel_set(DetectorId, ThreatIntelSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the threatIntelSet is associated
#' with.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet that you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_threat_intel_set(
#'   DetectorId = "string",
#'   ThreatIntelSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_threat_intel_set
guardduty_get_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "GetThreatIntelSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$get_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$get_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_threat_intel_set <- guardduty_get_threat_intel_set

#' Invites other AWS accounts (created as members of the current AWS
#' account by CreateMembers) to enable GuardDuty, and allow the current AWS
#' account to view and manage these accounts' GuardDuty findings on their
#' behalf as the master account
#'
#' Invites other AWS accounts (created as members of the current AWS
#' account by CreateMembers) to enable GuardDuty, and allow the current AWS
#' account to view and manage these accounts\' GuardDuty findings on their
#' behalf as the master account.
#'
#' @usage
#' guardduty_invite_members(DetectorId, AccountIds,
#'   DisableEmailNotification, Message)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' invite members with.
#' @param AccountIds &#91;required&#93; A list of account IDs of the accounts that you want to invite to
#' GuardDuty as members.
#' @param DisableEmailNotification A Boolean value that specifies whether you want to disable email
#' notification to the accounts that you're inviting to GuardDuty as
#' members.
#' @param Message The invitation message that you want to send to the accounts that you're
#' inviting to GuardDuty as members.
#'
#' @section Request syntax:
#' ```
#' svc$invite_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   ),
#'   DisableEmailNotification = TRUE|FALSE,
#'   Message = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_invite_members
guardduty_invite_members <- function(DetectorId, AccountIds, DisableEmailNotification = NULL, Message = NULL) {
  op <- new_operation(
    name = "InviteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/invite",
    paginator = list()
  )
  input <- .guardduty$invite_members_input(DetectorId = DetectorId, AccountIds = AccountIds, DisableEmailNotification = DisableEmailNotification, Message = Message)
  output <- .guardduty$invite_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$invite_members <- guardduty_invite_members

#' Lists detectorIds of all the existing Amazon GuardDuty detector
#' resources
#'
#' Lists detectorIds of all the existing Amazon GuardDuty detector
#' resources.
#'
#' @usage
#' guardduty_list_detectors(MaxResults, NextToken)
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_detectors(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_detectors
guardduty_list_detectors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDetectors",
    http_method = "GET",
    http_path = "/detector",
    paginator = list()
  )
  input <- .guardduty$list_detectors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_detectors <- guardduty_list_detectors

#' Returns a paginated list of the current filters
#'
#' Returns a paginated list of the current filters.
#'
#' @usage
#' guardduty_list_filters(DetectorId, MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the filter is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_filters(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_filters
guardduty_list_filters <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter",
    paginator = list()
  )
  input <- .guardduty$list_filters_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_filters_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_filters <- guardduty_list_filters

#' Lists Amazon GuardDuty findings for the specified detector ID
#'
#' Lists Amazon GuardDuty findings for the specified detector ID.
#'
#' @usage
#' guardduty_list_findings(DetectorId, FindingCriteria, SortCriteria,
#'   MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to list.
#' @param FindingCriteria Represents the criteria used for querying findings. Valid values
#' include:
#' 
#' -   JSON field name
#' 
#' -   accountId
#' 
#' -   region
#' 
#' -   confidence
#' 
#' -   id
#' 
#' -   resource.accessKeyDetails.accessKeyId
#' 
#' -   resource.accessKeyDetails.principalId
#' 
#' -   resource.accessKeyDetails.userName
#' 
#' -   resource.accessKeyDetails.userType
#' 
#' -   resource.instanceDetails.iamInstanceProfile.id
#' 
#' -   resource.instanceDetails.imageId
#' 
#' -   resource.instanceDetails.instanceId
#' 
#' -   resource.instanceDetails.networkInterfaces.ipv6Addresses
#' 
#' -   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
#' 
#' -   resource.instanceDetails.networkInterfaces.publicDnsName
#' 
#' -   resource.instanceDetails.networkInterfaces.publicIp
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupId
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupName
#' 
#' -   resource.instanceDetails.networkInterfaces.subnetId
#' 
#' -   resource.instanceDetails.networkInterfaces.vpcId
#' 
#' -   resource.instanceDetails.tags.key
#' 
#' -   resource.instanceDetails.tags.value
#' 
#' -   resource.resourceType
#' 
#' -   service.action.actionType
#' 
#' -   service.action.awsApiCallAction.api
#' 
#' -   service.action.awsApiCallAction.callerType
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.awsApiCallAction.serviceName
#' 
#' -   service.action.dnsRequestAction.domain
#' 
#' -   service.action.networkConnectionAction.blocked
#' 
#' -   service.action.networkConnectionAction.connectionDirection
#' 
#' -   service.action.networkConnectionAction.localPortDetails.port
#' 
#' -   service.action.networkConnectionAction.protocol
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.networkConnectionAction.remotePortDetails.port
#' 
#' -   service.additionalInfo.threatListName
#' 
#' -   service.archived
#' 
#'     When this attribute is set to \'true\', only archived findings are
#'     listed. When it\'s set to \'false\', only unarchived findings are
#'     listed. When this attribute is not set, all existing findings are
#'     listed.
#' 
#' -   service.resourceRole
#' 
#' -   severity
#' 
#' -   type
#' 
#' -   updatedAt
#' 
#'     Type: Timestamp in Unix Epoch millisecond format: 1486685375000
#' @param SortCriteria Represents the criteria used for sorting findings.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_findings(
#'   DetectorId = "string",
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   ),
#'   SortCriteria = list(
#'     AttributeName = "string",
#'     OrderBy = "ASC"|"DESC"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_findings
guardduty_list_findings <- function(DetectorId, FindingCriteria = NULL, SortCriteria = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings",
    paginator = list()
  )
  input <- .guardduty$list_findings_input(DetectorId = DetectorId, FindingCriteria = FindingCriteria, SortCriteria = SortCriteria, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_findings <- guardduty_list_findings

#' Lists the IPSets of the GuardDuty service specified by the detector ID
#'
#' Lists the IPSets of the GuardDuty service specified by the detector ID.
#' If you use this operation from a member account, the IPSets returned are
#' the IPSets from the associated master account.
#'
#' @usage
#' guardduty_list_ip_sets(DetectorId, MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the IPSet is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_ip_sets(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_ip_sets
guardduty_list_ip_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIPSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset",
    paginator = list()
  )
  input <- .guardduty$list_ip_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_ip_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_ip_sets <- guardduty_list_ip_sets

#' Lists all GuardDuty membership invitations that were sent to the current
#' AWS account
#'
#' Lists all GuardDuty membership invitations that were sent to the current
#' AWS account.
#'
#' @usage
#' guardduty_list_invitations(MaxResults, NextToken)
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_invitations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_invitations
guardduty_list_invitations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitation",
    paginator = list()
  )
  input <- .guardduty$list_invitations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_invitations <- guardduty_list_invitations

#' Lists details about all member accounts for the current GuardDuty master
#' account
#'
#' Lists details about all member accounts for the current GuardDuty master
#' account.
#'
#' @usage
#' guardduty_list_members(DetectorId, MaxResults, NextToken,
#'   OnlyAssociated)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the member is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#' @param OnlyAssociated Specifies whether to only return associated members or to return all
#' members (including members who haven\'t been invited yet or have been
#' disassociated).
#'
#' @section Request syntax:
#' ```
#' svc$list_members(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   OnlyAssociated = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_members
guardduty_list_members <- function(DetectorId, MaxResults = NULL, NextToken = NULL, OnlyAssociated = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/detector/{detectorId}/member",
    paginator = list()
  )
  input <- .guardduty$list_members_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken, OnlyAssociated = OnlyAssociated)
  output <- .guardduty$list_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_members <- guardduty_list_members

#' Lists the accounts configured as GuardDuty delegated administrators
#'
#' Lists the accounts configured as GuardDuty delegated administrators.
#'
#' @usage
#' guardduty_list_organization_admin_accounts(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @section Request syntax:
#' ```
#' svc$list_organization_admin_accounts(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_organization_admin_accounts
guardduty_list_organization_admin_accounts <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOrganizationAdminAccounts",
    http_method = "GET",
    http_path = "/admin",
    paginator = list()
  )
  input <- .guardduty$list_organization_admin_accounts_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_organization_admin_accounts_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_organization_admin_accounts <- guardduty_list_organization_admin_accounts

#' Returns a list of publishing destinations associated with the specified
#' dectectorId
#'
#' Returns a list of publishing destinations associated with the specified
#' `dectectorId`.
#'
#' @usage
#' guardduty_list_publishing_destinations(DetectorId, MaxResults,
#'   NextToken)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to retrieve publishing destinations for.
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @section Request syntax:
#' ```
#' svc$list_publishing_destinations(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_publishing_destinations
guardduty_list_publishing_destinations <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPublishingDestinations",
    http_method = "GET",
    http_path = "/detector/{detectorId}/publishingDestination",
    paginator = list()
  )
  input <- .guardduty$list_publishing_destinations_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_publishing_destinations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_publishing_destinations <- guardduty_list_publishing_destinations

#' Lists tags for a resource
#'
#' Lists tags for a resource. Tagging is currently supported for detectors,
#' finding filters, IP sets, and threat intel sets, with a limit of 50 tags
#' per resource. When invoked, this operation returns all assigned tags for
#' a given resource.
#'
#' @usage
#' guardduty_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the given GuardDuty resource.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_tags_for_resource
guardduty_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .guardduty$list_tags_for_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_tags_for_resource <- guardduty_list_tags_for_resource

#' Lists the ThreatIntelSets of the GuardDuty service specified by the
#' detector ID
#'
#' Lists the ThreatIntelSets of the GuardDuty service specified by the
#' detector ID. If you use this operation from a member account, the
#' ThreatIntelSets associated with the master account are returned.
#'
#' @usage
#' guardduty_list_threat_intel_sets(DetectorId, MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the threatIntelSet is associated
#' with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter to paginate results in the response. Set the
#' value of this parameter to null on your first call to the list action.
#' For subsequent calls to the action, fill nextToken in the request with
#' the value of NextToken from the previous response to continue listing
#' data.
#'
#' @section Request syntax:
#' ```
#' svc$list_threat_intel_sets(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_threat_intel_sets
guardduty_list_threat_intel_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListThreatIntelSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset",
    paginator = list()
  )
  input <- .guardduty$list_threat_intel_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_threat_intel_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_threat_intel_sets <- guardduty_list_threat_intel_sets

#' Turns on GuardDuty monitoring of the specified member accounts
#'
#' Turns on GuardDuty monitoring of the specified member accounts. Use this
#' operation to restart monitoring of accounts that you stopped monitoring
#' with the `StopMonitoringMembers` operation.
#'
#' @usage
#' guardduty_start_monitoring_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty master account associated
#' with the member accounts to monitor.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts to start
#' monitoring.
#'
#' @section Request syntax:
#' ```
#' svc$start_monitoring_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_start_monitoring_members
guardduty_start_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StartMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/start",
    paginator = list()
  )
  input <- .guardduty$start_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$start_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$start_monitoring_members <- guardduty_start_monitoring_members

#' Stops GuardDuty monitoring for the specified member accounts
#'
#' Stops GuardDuty monitoring for the specified member accounts. Use the
#' `StartMonitoringMembers` operation to restart monitoring for those
#' accounts.
#'
#' @usage
#' guardduty_stop_monitoring_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the GuardDuty master
#' account that is monitoring member accounts.
#' @param AccountIds &#91;required&#93; A list of account IDs for the member accounts to stop monitoring.
#'
#' @section Request syntax:
#' ```
#' svc$stop_monitoring_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_stop_monitoring_members
guardduty_stop_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StopMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/stop",
    paginator = list()
  )
  input <- .guardduty$stop_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$stop_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$stop_monitoring_members <- guardduty_stop_monitoring_members

#' Adds tags to a resource
#'
#' Adds tags to a resource.
#'
#' @usage
#' guardduty_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag
#' to.
#' @param Tags &#91;required&#93; The tags to be added to a resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_tag_resource
guardduty_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .guardduty$tag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$tag_resource <- guardduty_tag_resource

#' Unarchives GuardDuty findings specified by the findingIds
#'
#' Unarchives GuardDuty findings specified by the `findingIds`.
#'
#' @usage
#' guardduty_unarchive_findings(DetectorId, FindingIds)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the findings to unarchive.
#' @param FindingIds &#91;required&#93; The IDs of the findings to unarchive.
#'
#' @section Request syntax:
#' ```
#' svc$unarchive_findings(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_unarchive_findings
guardduty_unarchive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "UnarchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/unarchive",
    paginator = list()
  )
  input <- .guardduty$unarchive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$unarchive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$unarchive_findings <- guardduty_unarchive_findings

#' Removes tags from a resource
#'
#' Removes tags from a resource.
#'
#' @usage
#' guardduty_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource to remove tags from.
#' @param TagKeys &#91;required&#93; The tag keys to remove from the resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_untag_resource
guardduty_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .guardduty$untag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$untag_resource <- guardduty_untag_resource

#' Updates the Amazon GuardDuty detector specified by the detectorId
#'
#' Updates the Amazon GuardDuty detector specified by the detectorId.
#'
#' @usage
#' guardduty_update_detector(DetectorId, Enable,
#'   FindingPublishingFrequency)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector to update.
#' @param Enable Specifies whether the detector is enabled or not enabled.
#' @param FindingPublishingFrequency An enum value that specifies how frequently findings are exported, such
#' as to CloudWatch Events.
#'
#' @section Request syntax:
#' ```
#' svc$update_detector(
#'   DetectorId = "string",
#'   Enable = TRUE|FALSE,
#'   FindingPublishingFrequency = "FIFTEEN_MINUTES"|"ONE_HOUR"|"SIX_HOURS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_detector
guardduty_update_detector <- function(DetectorId, Enable = NULL, FindingPublishingFrequency = NULL) {
  op <- new_operation(
    name = "UpdateDetector",
    http_method = "POST",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$update_detector_input(DetectorId = DetectorId, Enable = Enable, FindingPublishingFrequency = FindingPublishingFrequency)
  output <- .guardduty$update_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_detector <- guardduty_update_detector

#' Updates the filter specified by the filter name
#'
#' Updates the filter specified by the filter name.
#'
#' @usage
#' guardduty_update_filter(DetectorId, FilterName, Description, Action,
#'   Rank, FindingCriteria)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that specifies the GuardDuty service where
#' you want to update a filter.
#' @param FilterName &#91;required&#93; The name of the filter.
#' @param Description The description of the filter.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria Represents the criteria to be used in the filter for querying findings.
#'
#' @section Request syntax:
#' ```
#' svc$update_filter(
#'   DetectorId = "string",
#'   FilterName = "string",
#'   Description = "string",
#'   Action = "NOOP"|"ARCHIVE",
#'   Rank = 123,
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_filter
guardduty_update_filter <- function(DetectorId, FilterName, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria = NULL) {
  op <- new_operation(
    name = "UpdateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$update_filter_input(DetectorId = DetectorId, FilterName = FilterName, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria)
  output <- .guardduty$update_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_filter <- guardduty_update_filter

#' Marks the specified GuardDuty findings as useful or not useful
#'
#' Marks the specified GuardDuty findings as useful or not useful.
#'
#' @usage
#' guardduty_update_findings_feedback(DetectorId, FindingIds, Feedback,
#'   Comments)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the findings to update feedback
#' for.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to mark as useful or not useful.
#' @param Feedback &#91;required&#93; The feedback for the finding.
#' @param Comments Additional feedback about the GuardDuty findings.
#'
#' @section Request syntax:
#' ```
#' svc$update_findings_feedback(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   ),
#'   Feedback = "USEFUL"|"NOT_USEFUL",
#'   Comments = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_findings_feedback
guardduty_update_findings_feedback <- function(DetectorId, FindingIds, Feedback, Comments = NULL) {
  op <- new_operation(
    name = "UpdateFindingsFeedback",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/feedback",
    paginator = list()
  )
  input <- .guardduty$update_findings_feedback_input(DetectorId = DetectorId, FindingIds = FindingIds, Feedback = Feedback, Comments = Comments)
  output <- .guardduty$update_findings_feedback_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_findings_feedback <- guardduty_update_findings_feedback

#' Updates the IPSet specified by the IPSet ID
#'
#' Updates the IPSet specified by the IPSet ID.
#'
#' @usage
#' guardduty_update_ip_set(DetectorId, IpSetId, Name, Location, Activate)
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose IPSet you want
#' to update.
#' @param IpSetId &#91;required&#93; The unique ID that specifies the IPSet that you want to update.
#' @param Name The unique ID that specifies the IPSet that you want to update.
#' @param Location The updated URI of the file that contains the IPSet. For example:
#' https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
#' @param Activate The updated Boolean value that specifies whether the IPSet is active or
#' not.
#'
#' @section Request syntax:
#' ```
#' svc$update_ip_set(
#'   DetectorId = "string",
#'   IpSetId = "string",
#'   Name = "string",
#'   Location = "string",
#'   Activate = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_ip_set
guardduty_update_ip_set <- function(DetectorId, IpSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$update_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_ip_set <- guardduty_update_ip_set

#' Updates the delegated administrator account with the values provided
#'
#' Updates the delegated administrator account with the values provided.
#'
#' @usage
#' guardduty_update_organization_configuration(DetectorId, AutoEnable)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to update the delegated administrator for.
#' @param AutoEnable &#91;required&#93; Indicates whether to automatically enable member accounts in the
#' organization.
#'
#' @section Request syntax:
#' ```
#' svc$update_organization_configuration(
#'   DetectorId = "string",
#'   AutoEnable = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_organization_configuration
guardduty_update_organization_configuration <- function(DetectorId, AutoEnable) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "POST",
    http_path = "/detector/{detectorId}/admin",
    paginator = list()
  )
  input <- .guardduty$update_organization_configuration_input(DetectorId = DetectorId, AutoEnable = AutoEnable)
  output <- .guardduty$update_organization_configuration_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_organization_configuration <- guardduty_update_organization_configuration

#' Updates information about the publishing destination specified by the
#' destinationId
#'
#' Updates information about the publishing destination specified by the
#' `destinationId`.
#'
#' @usage
#' guardduty_update_publishing_destination(DetectorId, DestinationId,
#'   DestinationProperties)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the publishing destinations to
#' update.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to update.
#' @param DestinationProperties A `DestinationProperties` object that includes the `DestinationArn` and
#' `KmsKeyArn` of the publishing destination.
#'
#' @section Request syntax:
#' ```
#' svc$update_publishing_destination(
#'   DetectorId = "string",
#'   DestinationId = "string",
#'   DestinationProperties = list(
#'     DestinationArn = "string",
#'     KmsKeyArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_publishing_destination
guardduty_update_publishing_destination <- function(DetectorId, DestinationId, DestinationProperties = NULL) {
  op <- new_operation(
    name = "UpdatePublishingDestination",
    http_method = "POST",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    paginator = list()
  )
  input <- .guardduty$update_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId, DestinationProperties = DestinationProperties)
  output <- .guardduty$update_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_publishing_destination <- guardduty_update_publishing_destination

#' Updates the ThreatIntelSet specified by the ThreatIntelSet ID
#'
#' Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
#'
#' @usage
#' guardduty_update_threat_intel_set(DetectorId, ThreatIntelSetId, Name,
#'   Location, Activate)
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose ThreatIntelSet
#' you want to update.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Name The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Location The updated URI of the file that contains the ThreateIntelSet. For
#' example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
#' @param Activate The updated Boolean value that specifies whether the ThreateIntelSet is
#' active or not.
#'
#' @section Request syntax:
#' ```
#' svc$update_threat_intel_set(
#'   DetectorId = "string",
#'   ThreatIntelSetId = "string",
#'   Name = "string",
#'   Location = "string",
#'   Activate = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_threat_intel_set
guardduty_update_threat_intel_set <- function(DetectorId, ThreatIntelSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$update_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_threat_intel_set <- guardduty_update_threat_intel_set
