% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_register_event_topic}
\alias{directoryservice_register_event_topic}
\title{Associates a directory with an SNS topic}
\usage{
directoryservice_register_event_topic(DirectoryId, TopicName)
}
\arguments{
\item{DirectoryId}{[required] The Directory ID that will publish status messages to the SNS topic.}

\item{TopicName}{[required] The SNS topic name to which the directory will publish status messages.
This SNS topic must be in the same region as the specified Directory ID.}
}
\description{
Associates a directory with an SNS topic. This establishes the directory
as a publisher to the specified SNS topic. You can then receive email or
text (SMS) messages when the status of your directory changes. You get
notified if your directory goes from an Active status to an Impaired or
Inoperable status. You also receive a notification when the directory
returns to an Active status.
}
\section{Request syntax}{
\preformatted{svc$register_event_topic(
  DirectoryId = "string",
  TopicName = "string"
)
}
}

\keyword{internal}
