# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudhsmv2_service.R
NULL

#' Copy an AWS CloudHSM cluster backup to a different region
#'
#' @description
#' Copy an AWS CloudHSM cluster backup to a different region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_copy_backup_to_region/](https://www.paws-r-sdk.com/docs/cloudhsmv2_copy_backup_to_region/) for full documentation.
#'
#' @param DestinationRegion &#91;required&#93; The AWS region that will contain your copied CloudHSM cluster backup.
#' @param BackupId &#91;required&#93; The ID of the backup that will be copied to the destination region.
#' @param TagList Tags to apply to the destination backup during creation. If you specify
#' tags, only these tags will be applied to the destination backup. If you
#' do not specify tags, the service copies tags from the source backup to
#' the destination backup.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_copy_backup_to_region
cloudhsmv2_copy_backup_to_region <- function(DestinationRegion, BackupId, TagList = NULL) {
  op <- new_operation(
    name = "CopyBackupToRegion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$copy_backup_to_region_input(DestinationRegion = DestinationRegion, BackupId = BackupId, TagList = TagList)
  output <- .cloudhsmv2$copy_backup_to_region_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$copy_backup_to_region <- cloudhsmv2_copy_backup_to_region

#' Creates a new AWS CloudHSM cluster
#'
#' @description
#' Creates a new AWS CloudHSM cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_create_cluster/](https://www.paws-r-sdk.com/docs/cloudhsmv2_create_cluster/) for full documentation.
#'
#' @param BackupRetentionPolicy A policy that defines how the service retains backups.
#' @param HsmType &#91;required&#93; The type of HSM to use in the cluster. Currently the only allowed value
#' is `hsm1.medium`.
#' @param SourceBackupId The identifier (ID) of the cluster backup to restore. Use this value to
#' restore the cluster from a backup instead of creating a new cluster. To
#' find the backup ID, use
#' [`describe_backups`][cloudhsmv2_describe_backups].
#' @param SubnetIds &#91;required&#93; The identifiers (IDs) of the subnets where you are creating the cluster.
#' You must specify at least one subnet. If you specify multiple subnets,
#' they must meet the following criteria:
#' 
#' -   All subnets must be in the same virtual private cloud (VPC).
#' 
#' -   You can specify only one subnet per Availability Zone.
#' @param TagList Tags to apply to the CloudHSM cluster during creation.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_create_cluster
cloudhsmv2_create_cluster <- function(BackupRetentionPolicy = NULL, HsmType, SourceBackupId = NULL, SubnetIds, TagList = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$create_cluster_input(BackupRetentionPolicy = BackupRetentionPolicy, HsmType = HsmType, SourceBackupId = SourceBackupId, SubnetIds = SubnetIds, TagList = TagList)
  output <- .cloudhsmv2$create_cluster_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$create_cluster <- cloudhsmv2_create_cluster

#' Creates a new hardware security module (HSM) in the specified AWS
#' CloudHSM cluster
#'
#' @description
#' Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_create_hsm/](https://www.paws-r-sdk.com/docs/cloudhsmv2_create_hsm/) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier (ID) of the HSM's cluster. To find the cluster ID, use
#' [`describe_clusters`][cloudhsmv2_describe_clusters].
#' @param AvailabilityZone &#91;required&#93; The Availability Zone where you are creating the HSM. To find the
#' cluster's Availability Zones, use
#' [`describe_clusters`][cloudhsmv2_describe_clusters].
#' @param IpAddress The HSM's IP address. If you specify an IP address, use an available
#' address from the subnet that maps to the Availability Zone where you are
#' creating the HSM. If you don't specify an IP address, one is chosen for
#' you from that subnet.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_create_hsm
cloudhsmv2_create_hsm <- function(ClusterId, AvailabilityZone, IpAddress = NULL) {
  op <- new_operation(
    name = "CreateHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$create_hsm_input(ClusterId = ClusterId, AvailabilityZone = AvailabilityZone, IpAddress = IpAddress)
  output <- .cloudhsmv2$create_hsm_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$create_hsm <- cloudhsmv2_create_hsm

#' Deletes a specified AWS CloudHSM backup
#'
#' @description
#' Deletes a specified AWS CloudHSM backup. A backup can be restored up to 7 days after the DeleteBackup request is made. For more information on restoring a backup, see [`restore_backup`][cloudhsmv2_restore_backup].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_delete_backup/](https://www.paws-r-sdk.com/docs/cloudhsmv2_delete_backup/) for full documentation.
#'
#' @param BackupId &#91;required&#93; The ID of the backup to be deleted. To find the ID of a backup, use the
#' [`describe_backups`][cloudhsmv2_describe_backups] operation.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_delete_backup
cloudhsmv2_delete_backup <- function(BackupId) {
  op <- new_operation(
    name = "DeleteBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$delete_backup_input(BackupId = BackupId)
  output <- .cloudhsmv2$delete_backup_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$delete_backup <- cloudhsmv2_delete_backup

#' Deletes the specified AWS CloudHSM cluster
#'
#' @description
#' Deletes the specified AWS CloudHSM cluster. Before you can delete a cluster, you must delete all HSMs in the cluster. To see if the cluster contains any HSMs, use [`describe_clusters`][cloudhsmv2_describe_clusters]. To delete an HSM, use [`delete_hsm`][cloudhsmv2_delete_hsm].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_delete_cluster/](https://www.paws-r-sdk.com/docs/cloudhsmv2_delete_cluster/) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier (ID) of the cluster that you are deleting. To find the
#' cluster ID, use [`describe_clusters`][cloudhsmv2_describe_clusters].
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_delete_cluster
cloudhsmv2_delete_cluster <- function(ClusterId) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$delete_cluster_input(ClusterId = ClusterId)
  output <- .cloudhsmv2$delete_cluster_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$delete_cluster <- cloudhsmv2_delete_cluster

#' Deletes the specified HSM
#'
#' @description
#' Deletes the specified HSM. To specify an HSM, you can use its identifier (ID), the IP address of the HSM's elastic network interface (ENI), or the ID of the HSM's ENI. You need to specify only one of these values. To find these values, use [`describe_clusters`][cloudhsmv2_describe_clusters].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_delete_hsm/](https://www.paws-r-sdk.com/docs/cloudhsmv2_delete_hsm/) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier (ID) of the cluster that contains the HSM that you are
#' deleting.
#' @param HsmId The identifier (ID) of the HSM that you are deleting.
#' @param EniId The identifier (ID) of the elastic network interface (ENI) of the HSM
#' that you are deleting.
#' @param EniIp The IP address of the elastic network interface (ENI) of the HSM that
#' you are deleting.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_delete_hsm
cloudhsmv2_delete_hsm <- function(ClusterId, HsmId = NULL, EniId = NULL, EniIp = NULL) {
  op <- new_operation(
    name = "DeleteHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$delete_hsm_input(ClusterId = ClusterId, HsmId = HsmId, EniId = EniId, EniIp = EniIp)
  output <- .cloudhsmv2$delete_hsm_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$delete_hsm <- cloudhsmv2_delete_hsm

#' Gets information about backups of AWS CloudHSM clusters
#'
#' @description
#' Gets information about backups of AWS CloudHSM clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_describe_backups/](https://www.paws-r-sdk.com/docs/cloudhsmv2_describe_backups/) for full documentation.
#'
#' @param NextToken The `NextToken` value that you received in the previous response. Use
#' this value to get more backups.
#' @param MaxResults The maximum number of backups to return in the response. When there are
#' more backups than the number you specify, the response contains a
#' `NextToken` value.
#' @param Filters One or more filters to limit the items returned in the response.
#' 
#' Use the `backupIds` filter to return only the specified backups. Specify
#' backups by their backup identifier (ID).
#' 
#' Use the `sourceBackupIds` filter to return only the backups created from
#' a source backup. The `sourceBackupID` of a source backup is returned by
#' the [`copy_backup_to_region`][cloudhsmv2_copy_backup_to_region]
#' operation.
#' 
#' Use the `clusterIds` filter to return only the backups for the specified
#' clusters. Specify clusters by their cluster identifier (ID).
#' 
#' Use the `states` filter to return only backups that match the specified
#' state.
#' 
#' Use the `neverExpires` filter to return backups filtered by the value in
#' the `neverExpires` parameter. `True` returns all backups exempt from the
#' backup retention policy. `False` returns all backups with a backup
#' retention policy defined at the cluster.
#' @param SortAscending Designates whether or not to sort the return backups by ascending
#' chronological order of generation.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_describe_backups
cloudhsmv2_describe_backups <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL, SortAscending = NULL) {
  op <- new_operation(
    name = "DescribeBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$describe_backups_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, SortAscending = SortAscending)
  output <- .cloudhsmv2$describe_backups_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$describe_backups <- cloudhsmv2_describe_backups

#' Gets information about AWS CloudHSM clusters
#'
#' @description
#' Gets information about AWS CloudHSM clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_describe_clusters/](https://www.paws-r-sdk.com/docs/cloudhsmv2_describe_clusters/) for full documentation.
#'
#' @param Filters One or more filters to limit the items returned in the response.
#' 
#' Use the `clusterIds` filter to return only the specified clusters.
#' Specify clusters by their cluster identifier (ID).
#' 
#' Use the `vpcIds` filter to return only the clusters in the specified
#' virtual private clouds (VPCs). Specify VPCs by their VPC identifier
#' (ID).
#' 
#' Use the `states` filter to return only clusters that match the specified
#' state.
#' @param NextToken The `NextToken` value that you received in the previous response. Use
#' this value to get more clusters.
#' @param MaxResults The maximum number of clusters to return in the response. When there are
#' more clusters than the number you specify, the response contains a
#' `NextToken` value.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_describe_clusters
cloudhsmv2_describe_clusters <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$describe_clusters_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudhsmv2$describe_clusters_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$describe_clusters <- cloudhsmv2_describe_clusters

#' Claims an AWS CloudHSM cluster by submitting the cluster certificate
#' issued by your issuing certificate authority (CA) and the CA's root
#' certificate
#'
#' @description
#' Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate. Before you can claim a cluster, you must sign the cluster's certificate signing request (CSR) with your issuing CA. To get the cluster's CSR, use [`describe_clusters`][cloudhsmv2_describe_clusters].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_initialize_cluster/](https://www.paws-r-sdk.com/docs/cloudhsmv2_initialize_cluster/) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier (ID) of the cluster that you are claiming. To find the
#' cluster ID, use [`describe_clusters`][cloudhsmv2_describe_clusters].
#' @param SignedCert &#91;required&#93; The cluster certificate issued (signed) by your issuing certificate
#' authority (CA). The certificate must be in PEM format and can contain a
#' maximum of 5000 characters.
#' @param TrustAnchor &#91;required&#93; The issuing certificate of the issuing certificate authority (CA) that
#' issued (signed) the cluster certificate. You must use a self-signed
#' certificate. The certificate used to sign the HSM CSR must be directly
#' available, and thus must be the root certificate. The certificate must
#' be in PEM format and can contain a maximum of 5000 characters.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_initialize_cluster
cloudhsmv2_initialize_cluster <- function(ClusterId, SignedCert, TrustAnchor) {
  op <- new_operation(
    name = "InitializeCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$initialize_cluster_input(ClusterId = ClusterId, SignedCert = SignedCert, TrustAnchor = TrustAnchor)
  output <- .cloudhsmv2$initialize_cluster_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$initialize_cluster <- cloudhsmv2_initialize_cluster

#' Gets a list of tags for the specified AWS CloudHSM cluster
#'
#' @description
#' Gets a list of tags for the specified AWS CloudHSM cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_list_tags/](https://www.paws-r-sdk.com/docs/cloudhsmv2_list_tags/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The cluster identifier (ID) for the cluster whose tags you are getting.
#' To find the cluster ID, use
#' [`describe_clusters`][cloudhsmv2_describe_clusters].
#' @param NextToken The `NextToken` value that you received in the previous response. Use
#' this value to get more tags.
#' @param MaxResults The maximum number of tags to return in the response. When there are
#' more tags than the number you specify, the response contains a
#' `NextToken` value.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_list_tags
cloudhsmv2_list_tags <- function(ResourceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$list_tags_input(ResourceId = ResourceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudhsmv2$list_tags_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$list_tags <- cloudhsmv2_list_tags

#' Modifies attributes for AWS CloudHSM backup
#'
#' @description
#' Modifies attributes for AWS CloudHSM backup.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_modify_backup_attributes/](https://www.paws-r-sdk.com/docs/cloudhsmv2_modify_backup_attributes/) for full documentation.
#'
#' @param BackupId &#91;required&#93; The identifier (ID) of the backup to modify. To find the ID of a backup,
#' use the [`describe_backups`][cloudhsmv2_describe_backups] operation.
#' @param NeverExpires &#91;required&#93; Specifies whether the service should exempt a backup from the retention
#' policy for the cluster. `True` exempts a backup from the retention
#' policy. `False` means the service applies the backup retention policy
#' defined at the cluster.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_modify_backup_attributes
cloudhsmv2_modify_backup_attributes <- function(BackupId, NeverExpires) {
  op <- new_operation(
    name = "ModifyBackupAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$modify_backup_attributes_input(BackupId = BackupId, NeverExpires = NeverExpires)
  output <- .cloudhsmv2$modify_backup_attributes_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$modify_backup_attributes <- cloudhsmv2_modify_backup_attributes

#' Modifies AWS CloudHSM cluster
#'
#' @description
#' Modifies AWS CloudHSM cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_modify_cluster/](https://www.paws-r-sdk.com/docs/cloudhsmv2_modify_cluster/) for full documentation.
#'
#' @param BackupRetentionPolicy &#91;required&#93; A policy that defines how the service retains backups.
#' @param ClusterId &#91;required&#93; The identifier (ID) of the cluster that you want to modify. To find the
#' cluster ID, use [`describe_clusters`][cloudhsmv2_describe_clusters].
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_modify_cluster
cloudhsmv2_modify_cluster <- function(BackupRetentionPolicy, ClusterId) {
  op <- new_operation(
    name = "ModifyCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$modify_cluster_input(BackupRetentionPolicy = BackupRetentionPolicy, ClusterId = ClusterId)
  output <- .cloudhsmv2$modify_cluster_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$modify_cluster <- cloudhsmv2_modify_cluster

#' Restores a specified AWS CloudHSM backup that is in the PENDING_DELETION
#' state
#'
#' @description
#' Restores a specified AWS CloudHSM backup that is in the `PENDING_DELETION` state. For mor information on deleting a backup, see [`delete_backup`][cloudhsmv2_delete_backup].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_restore_backup/](https://www.paws-r-sdk.com/docs/cloudhsmv2_restore_backup/) for full documentation.
#'
#' @param BackupId &#91;required&#93; The ID of the backup to be restored. To find the ID of a backup, use the
#' [`describe_backups`][cloudhsmv2_describe_backups] operation.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_restore_backup
cloudhsmv2_restore_backup <- function(BackupId) {
  op <- new_operation(
    name = "RestoreBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$restore_backup_input(BackupId = BackupId)
  output <- .cloudhsmv2$restore_backup_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$restore_backup <- cloudhsmv2_restore_backup

#' Adds or overwrites one or more tags for the specified AWS CloudHSM
#' cluster
#'
#' @description
#' Adds or overwrites one or more tags for the specified AWS CloudHSM cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_tag_resource/](https://www.paws-r-sdk.com/docs/cloudhsmv2_tag_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The cluster identifier (ID) for the cluster that you are tagging. To
#' find the cluster ID, use
#' [`describe_clusters`][cloudhsmv2_describe_clusters].
#' @param TagList &#91;required&#93; A list of one or more tags.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_tag_resource
cloudhsmv2_tag_resource <- function(ResourceId, TagList) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$tag_resource_input(ResourceId = ResourceId, TagList = TagList)
  output <- .cloudhsmv2$tag_resource_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$tag_resource <- cloudhsmv2_tag_resource

#' Removes the specified tag or tags from the specified AWS CloudHSM
#' cluster
#'
#' @description
#' Removes the specified tag or tags from the specified AWS CloudHSM cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsmv2_untag_resource/](https://www.paws-r-sdk.com/docs/cloudhsmv2_untag_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The cluster identifier (ID) for the cluster whose tags you are removing.
#' To find the cluster ID, use
#' [`describe_clusters`][cloudhsmv2_describe_clusters].
#' @param TagKeyList &#91;required&#93; A list of one or more tag keys for the tags that you are removing.
#' Specify only the tag keys, not the tag values.
#'
#' @keywords internal
#'
#' @rdname cloudhsmv2_untag_resource
cloudhsmv2_untag_resource <- function(ResourceId, TagKeyList) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsmv2$untag_resource_input(ResourceId = ResourceId, TagKeyList = TagKeyList)
  output <- .cloudhsmv2$untag_resource_output()
  config <- get_config()
  svc <- .cloudhsmv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsmv2$operations$untag_resource <- cloudhsmv2_untag_resource
