# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ssoadmin_service.R
NULL

#' Attaches the specified customer managed policy to the specified
#' PermissionSet
#'
#' @description
#' Attaches the specified customer managed policy to the specified PermissionSet.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_attach_customer_managed_policy_reference_to_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_attach_customer_managed_policy_reference_to_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param PermissionSetArn &#91;required&#93; The ARN of the `PermissionSet`.
#' @param CustomerManagedPolicyReference &#91;required&#93; Specifies the name and path of a customer managed policy. You must have
#' an IAM policy that matches the name and path in each AWS account where
#' you want to deploy your permission set.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_attac_custo_manag_polic_refer_to_permi_set
ssoadmin_attach_customer_managed_policy_reference_to_permission_set <- function(InstanceArn, PermissionSetArn, CustomerManagedPolicyReference) {
  op <- new_operation(
    name = "AttachCustomerManagedPolicyReferenceToPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$attach_customer_managed_policy_reference_to_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, CustomerManagedPolicyReference = CustomerManagedPolicyReference)
  output <- .ssoadmin$attach_customer_managed_policy_reference_to_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$attach_customer_managed_policy_reference_to_permission_set <- ssoadmin_attach_customer_managed_policy_reference_to_permission_set

#' Attaches an AWS managed policy ARN to a permission set
#'
#' @description
#' Attaches an AWS managed policy ARN to a permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_attach_managed_policy_to_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_attach_managed_policy_to_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the PermissionSet that the managed policy should be attached
#' to.
#' @param ManagedPolicyArn &#91;required&#93; The AWS managed policy ARN to be attached to a permission set.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_attach_managed_policy_to_permission_set
ssoadmin_attach_managed_policy_to_permission_set <- function(InstanceArn, PermissionSetArn, ManagedPolicyArn) {
  op <- new_operation(
    name = "AttachManagedPolicyToPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$attach_managed_policy_to_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, ManagedPolicyArn = ManagedPolicyArn)
  output <- .ssoadmin$attach_managed_policy_to_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$attach_managed_policy_to_permission_set <- ssoadmin_attach_managed_policy_to_permission_set

#' Assigns access to a principal for a specified AWS account using a
#' specified permission set
#'
#' @description
#' Assigns access to a principal for a specified AWS account using a specified permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_create_account_assignment/](https://www.paws-r-sdk.com/docs/ssoadmin_create_account_assignment/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param TargetId &#91;required&#93; TargetID is an AWS account identifier, typically a 10-12 digit string
#' (For example, 123456789012).
#' @param TargetType &#91;required&#93; The entity type for which the assignment will be created.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set that the admin wants to grant the
#' principal access to.
#' @param PrincipalType &#91;required&#93; The entity type for which the assignment will be created.
#' @param PrincipalId &#91;required&#93; An identifier for an object in IAM Identity Center, such as a user or
#' group. PrincipalIds are GUIDs (For example,
#' f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about
#' PrincipalIds in IAM Identity Center, see the IAM Identity Center
#' Identity Store API Reference.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_create_account_assignment
ssoadmin_create_account_assignment <- function(InstanceArn, TargetId, TargetType, PermissionSetArn, PrincipalType, PrincipalId) {
  op <- new_operation(
    name = "CreateAccountAssignment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$create_account_assignment_input(InstanceArn = InstanceArn, TargetId = TargetId, TargetType = TargetType, PermissionSetArn = PermissionSetArn, PrincipalType = PrincipalType, PrincipalId = PrincipalId)
  output <- .ssoadmin$create_account_assignment_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$create_account_assignment <- ssoadmin_create_account_assignment

#' Enables the attributes-based access control (ABAC) feature for the
#' specified IAM Identity Center instance
#'
#' @description
#' Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see Attribute-Based Access Control in the *IAM Identity Center User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_create_instance_access_control_attribute_configuration/](https://www.paws-r-sdk.com/docs/ssoadmin_create_instance_access_control_attribute_configuration/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param InstanceAccessControlAttributeConfiguration &#91;required&#93; Specifies the IAM Identity Center identity store attributes to add to
#' your ABAC configuration. When using an external identity provider as an
#' identity source, you can pass attributes through the SAML assertion.
#' Doing so provides an alternative to configuring attributes from the IAM
#' Identity Center identity store. If a SAML assertion passes any of these
#' attributes, IAM Identity Center will replace the attribute value with
#' the value from the IAM Identity Center identity store.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_create_instanc_access_control_attribu_configu
ssoadmin_create_instance_access_control_attribute_configuration <- function(InstanceArn, InstanceAccessControlAttributeConfiguration) {
  op <- new_operation(
    name = "CreateInstanceAccessControlAttributeConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$create_instance_access_control_attribute_configuration_input(InstanceArn = InstanceArn, InstanceAccessControlAttributeConfiguration = InstanceAccessControlAttributeConfiguration)
  output <- .ssoadmin$create_instance_access_control_attribute_configuration_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$create_instance_access_control_attribute_configuration <- ssoadmin_create_instance_access_control_attribute_configuration

#' Creates a permission set within a specified IAM Identity Center instance
#'
#' @description
#' Creates a permission set within a specified IAM Identity Center instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_create_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_create_permission_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the PermissionSet.
#' @param Description The description of the PermissionSet.
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param SessionDuration The length of time that the application user sessions are valid in the
#' ISO-8601 standard.
#' @param RelayState Used to redirect users within the application during the federation
#' authentication process.
#' @param Tags The tags to attach to the new PermissionSet.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_create_permission_set
ssoadmin_create_permission_set <- function(Name, Description = NULL, InstanceArn, SessionDuration = NULL, RelayState = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$create_permission_set_input(Name = Name, Description = Description, InstanceArn = InstanceArn, SessionDuration = SessionDuration, RelayState = RelayState, Tags = Tags)
  output <- .ssoadmin$create_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$create_permission_set <- ssoadmin_create_permission_set

#' Deletes a principal's access from a specified AWS account using a
#' specified permission set
#'
#' @description
#' Deletes a principal's access from a specified AWS account using a specified permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_delete_account_assignment/](https://www.paws-r-sdk.com/docs/ssoadmin_delete_account_assignment/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param TargetId &#91;required&#93; TargetID is an AWS account identifier, typically a 10-12 digit string
#' (For example, 123456789012).
#' @param TargetType &#91;required&#93; The entity type for which the assignment will be deleted.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set that will be used to remove access.
#' @param PrincipalType &#91;required&#93; The entity type for which the assignment will be deleted.
#' @param PrincipalId &#91;required&#93; An identifier for an object in IAM Identity Center, such as a user or
#' group. PrincipalIds are GUIDs (For example,
#' f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about
#' PrincipalIds in IAM Identity Center, see the IAM Identity Center
#' Identity Store API Reference.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_delete_account_assignment
ssoadmin_delete_account_assignment <- function(InstanceArn, TargetId, TargetType, PermissionSetArn, PrincipalType, PrincipalId) {
  op <- new_operation(
    name = "DeleteAccountAssignment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$delete_account_assignment_input(InstanceArn = InstanceArn, TargetId = TargetId, TargetType = TargetType, PermissionSetArn = PermissionSetArn, PrincipalType = PrincipalType, PrincipalId = PrincipalId)
  output <- .ssoadmin$delete_account_assignment_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$delete_account_assignment <- ssoadmin_delete_account_assignment

#' Deletes the inline policy from a specified permission set
#'
#' @description
#' Deletes the inline policy from a specified permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_delete_inline_policy_from_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_delete_inline_policy_from_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set that will be used to remove access.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_delete_inline_policy_from_permission_set
ssoadmin_delete_inline_policy_from_permission_set <- function(InstanceArn, PermissionSetArn) {
  op <- new_operation(
    name = "DeleteInlinePolicyFromPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$delete_inline_policy_from_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn)
  output <- .ssoadmin$delete_inline_policy_from_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$delete_inline_policy_from_permission_set <- ssoadmin_delete_inline_policy_from_permission_set

#' Disables the attributes-based access control (ABAC) feature for the
#' specified IAM Identity Center instance and deletes all of the attribute
#' mappings that have been configured
#'
#' @description
#' Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see Attribute-Based Access Control in the *IAM Identity Center User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_delete_instance_access_control_attribute_configuration/](https://www.paws-r-sdk.com/docs/ssoadmin_delete_instance_access_control_attribute_configuration/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_delete_instanc_access_control_attribu_configu
ssoadmin_delete_instance_access_control_attribute_configuration <- function(InstanceArn) {
  op <- new_operation(
    name = "DeleteInstanceAccessControlAttributeConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$delete_instance_access_control_attribute_configuration_input(InstanceArn = InstanceArn)
  output <- .ssoadmin$delete_instance_access_control_attribute_configuration_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$delete_instance_access_control_attribute_configuration <- ssoadmin_delete_instance_access_control_attribute_configuration

#' Deletes the specified permission set
#'
#' @description
#' Deletes the specified permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_delete_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_delete_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set that should be deleted.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_delete_permission_set
ssoadmin_delete_permission_set <- function(InstanceArn, PermissionSetArn) {
  op <- new_operation(
    name = "DeletePermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$delete_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn)
  output <- .ssoadmin$delete_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$delete_permission_set <- ssoadmin_delete_permission_set

#' Deletes the permissions boundary from a specified PermissionSet
#'
#' @description
#' Deletes the permissions boundary from a specified PermissionSet.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_delete_permissions_boundary_from_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_delete_permissions_boundary_from_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param PermissionSetArn &#91;required&#93; The ARN of the `PermissionSet`.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_delete_permissions_boundary_from_permission_set
ssoadmin_delete_permissions_boundary_from_permission_set <- function(InstanceArn, PermissionSetArn) {
  op <- new_operation(
    name = "DeletePermissionsBoundaryFromPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$delete_permissions_boundary_from_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn)
  output <- .ssoadmin$delete_permissions_boundary_from_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$delete_permissions_boundary_from_permission_set <- ssoadmin_delete_permissions_boundary_from_permission_set

#' Describes the status of the assignment creation request
#'
#' @description
#' Describes the status of the assignment creation request.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_describe_account_assignment_creation_status/](https://www.paws-r-sdk.com/docs/ssoadmin_describe_account_assignment_creation_status/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param AccountAssignmentCreationRequestId &#91;required&#93; The identifier that is used to track the request operation progress.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_describe_account_assignment_creation_status
ssoadmin_describe_account_assignment_creation_status <- function(InstanceArn, AccountAssignmentCreationRequestId) {
  op <- new_operation(
    name = "DescribeAccountAssignmentCreationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$describe_account_assignment_creation_status_input(InstanceArn = InstanceArn, AccountAssignmentCreationRequestId = AccountAssignmentCreationRequestId)
  output <- .ssoadmin$describe_account_assignment_creation_status_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$describe_account_assignment_creation_status <- ssoadmin_describe_account_assignment_creation_status

#' Describes the status of the assignment deletion request
#'
#' @description
#' Describes the status of the assignment deletion request.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_describe_account_assignment_deletion_status/](https://www.paws-r-sdk.com/docs/ssoadmin_describe_account_assignment_deletion_status/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param AccountAssignmentDeletionRequestId &#91;required&#93; The identifier that is used to track the request operation progress.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_describe_account_assignment_deletion_status
ssoadmin_describe_account_assignment_deletion_status <- function(InstanceArn, AccountAssignmentDeletionRequestId) {
  op <- new_operation(
    name = "DescribeAccountAssignmentDeletionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$describe_account_assignment_deletion_status_input(InstanceArn = InstanceArn, AccountAssignmentDeletionRequestId = AccountAssignmentDeletionRequestId)
  output <- .ssoadmin$describe_account_assignment_deletion_status_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$describe_account_assignment_deletion_status <- ssoadmin_describe_account_assignment_deletion_status

#' Returns the list of IAM Identity Center identity store attributes that
#' have been configured to work with attributes-based access control (ABAC)
#' for the specified IAM Identity Center instance
#'
#' @description
#' Returns the list of IAM Identity Center identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see Attribute-Based Access Control in the *IAM Identity Center User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_describe_instance_access_control_attribute_configuration/](https://www.paws-r-sdk.com/docs/ssoadmin_describe_instance_access_control_attribute_configuration/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_describ_instanc_access_control_attribu_configu
ssoadmin_describe_instance_access_control_attribute_configuration <- function(InstanceArn) {
  op <- new_operation(
    name = "DescribeInstanceAccessControlAttributeConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$describe_instance_access_control_attribute_configuration_input(InstanceArn = InstanceArn)
  output <- .ssoadmin$describe_instance_access_control_attribute_configuration_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$describe_instance_access_control_attribute_configuration <- ssoadmin_describe_instance_access_control_attribute_configuration

#' Gets the details of the permission set
#'
#' @description
#' Gets the details of the permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_describe_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_describe_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_describe_permission_set
ssoadmin_describe_permission_set <- function(InstanceArn, PermissionSetArn) {
  op <- new_operation(
    name = "DescribePermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$describe_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn)
  output <- .ssoadmin$describe_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$describe_permission_set <- ssoadmin_describe_permission_set

#' Describes the status for the given permission set provisioning request
#'
#' @description
#' Describes the status for the given permission set provisioning request.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_describe_permission_set_provisioning_status/](https://www.paws-r-sdk.com/docs/ssoadmin_describe_permission_set_provisioning_status/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param ProvisionPermissionSetRequestId &#91;required&#93; The identifier that is provided by the
#' [`provision_permission_set`][ssoadmin_provision_permission_set] call to
#' retrieve the current status of the provisioning workflow.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_describe_permission_set_provisioning_status
ssoadmin_describe_permission_set_provisioning_status <- function(InstanceArn, ProvisionPermissionSetRequestId) {
  op <- new_operation(
    name = "DescribePermissionSetProvisioningStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$describe_permission_set_provisioning_status_input(InstanceArn = InstanceArn, ProvisionPermissionSetRequestId = ProvisionPermissionSetRequestId)
  output <- .ssoadmin$describe_permission_set_provisioning_status_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$describe_permission_set_provisioning_status <- ssoadmin_describe_permission_set_provisioning_status

#' Detaches the specified customer managed policy from the specified
#' PermissionSet
#'
#' @description
#' Detaches the specified customer managed policy from the specified PermissionSet.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_detach_customer_managed_policy_reference_from_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_detach_customer_managed_policy_reference_from_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param PermissionSetArn &#91;required&#93; The ARN of the `PermissionSet`.
#' @param CustomerManagedPolicyReference &#91;required&#93; Specifies the name and path of a customer managed policy. You must have
#' an IAM policy that matches the name and path in each AWS account where
#' you want to deploy your permission set.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_detac_custo_manag_polic_refer_from_permi_set
ssoadmin_detach_customer_managed_policy_reference_from_permission_set <- function(InstanceArn, PermissionSetArn, CustomerManagedPolicyReference) {
  op <- new_operation(
    name = "DetachCustomerManagedPolicyReferenceFromPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$detach_customer_managed_policy_reference_from_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, CustomerManagedPolicyReference = CustomerManagedPolicyReference)
  output <- .ssoadmin$detach_customer_managed_policy_reference_from_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$detach_customer_managed_policy_reference_from_permission_set <- ssoadmin_detach_customer_managed_policy_reference_from_permission_set

#' Detaches the attached AWS managed policy ARN from the specified
#' permission set
#'
#' @description
#' Detaches the attached AWS managed policy ARN from the specified permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_detach_managed_policy_from_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_detach_managed_policy_from_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the PermissionSet from which the policy should be detached.
#' @param ManagedPolicyArn &#91;required&#93; The AWS managed policy ARN to be detached from a permission set.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_detach_managed_policy_from_permission_set
ssoadmin_detach_managed_policy_from_permission_set <- function(InstanceArn, PermissionSetArn, ManagedPolicyArn) {
  op <- new_operation(
    name = "DetachManagedPolicyFromPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$detach_managed_policy_from_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, ManagedPolicyArn = ManagedPolicyArn)
  output <- .ssoadmin$detach_managed_policy_from_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$detach_managed_policy_from_permission_set <- ssoadmin_detach_managed_policy_from_permission_set

#' Obtains the inline policy assigned to the permission set
#'
#' @description
#' Obtains the inline policy assigned to the permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_get_inline_policy_for_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_get_inline_policy_for_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_get_inline_policy_for_permission_set
ssoadmin_get_inline_policy_for_permission_set <- function(InstanceArn, PermissionSetArn) {
  op <- new_operation(
    name = "GetInlinePolicyForPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$get_inline_policy_for_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn)
  output <- .ssoadmin$get_inline_policy_for_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$get_inline_policy_for_permission_set <- ssoadmin_get_inline_policy_for_permission_set

#' Obtains the permissions boundary for a specified PermissionSet
#'
#' @description
#' Obtains the permissions boundary for a specified PermissionSet.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_get_permissions_boundary_for_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_get_permissions_boundary_for_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param PermissionSetArn &#91;required&#93; The ARN of the `PermissionSet`.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_get_permissions_boundary_for_permission_set
ssoadmin_get_permissions_boundary_for_permission_set <- function(InstanceArn, PermissionSetArn) {
  op <- new_operation(
    name = "GetPermissionsBoundaryForPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$get_permissions_boundary_for_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn)
  output <- .ssoadmin$get_permissions_boundary_for_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$get_permissions_boundary_for_permission_set <- ssoadmin_get_permissions_boundary_for_permission_set

#' Lists the status of the AWS account assignment creation requests for a
#' specified IAM Identity Center instance
#'
#' @description
#' Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_account_assignment_creation_status/](https://www.paws-r-sdk.com/docs/ssoadmin_list_account_assignment_creation_status/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param MaxResults The maximum number of results to display for the assignment.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#' @param Filter Filters results based on the passed attribute value.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_account_assignment_creation_status
ssoadmin_list_account_assignment_creation_status <- function(InstanceArn, MaxResults = NULL, NextToken = NULL, Filter = NULL) {
  op <- new_operation(
    name = "ListAccountAssignmentCreationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_account_assignment_creation_status_input(InstanceArn = InstanceArn, MaxResults = MaxResults, NextToken = NextToken, Filter = Filter)
  output <- .ssoadmin$list_account_assignment_creation_status_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_account_assignment_creation_status <- ssoadmin_list_account_assignment_creation_status

#' Lists the status of the AWS account assignment deletion requests for a
#' specified IAM Identity Center instance
#'
#' @description
#' Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_account_assignment_deletion_status/](https://www.paws-r-sdk.com/docs/ssoadmin_list_account_assignment_deletion_status/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param MaxResults The maximum number of results to display for the assignment.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#' @param Filter Filters results based on the passed attribute value.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_account_assignment_deletion_status
ssoadmin_list_account_assignment_deletion_status <- function(InstanceArn, MaxResults = NULL, NextToken = NULL, Filter = NULL) {
  op <- new_operation(
    name = "ListAccountAssignmentDeletionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_account_assignment_deletion_status_input(InstanceArn = InstanceArn, MaxResults = MaxResults, NextToken = NextToken, Filter = Filter)
  output <- .ssoadmin$list_account_assignment_deletion_status_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_account_assignment_deletion_status <- ssoadmin_list_account_assignment_deletion_status

#' Lists the assignee of the specified AWS account with the specified
#' permission set
#'
#' @description
#' Lists the assignee of the specified AWS account with the specified permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_account_assignments/](https://www.paws-r-sdk.com/docs/ssoadmin_list_account_assignments/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param AccountId &#91;required&#93; The identifier of the AWS account from which to list the assignments.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set from which to list assignments.
#' @param MaxResults The maximum number of results to display for the assignment.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_account_assignments
ssoadmin_list_account_assignments <- function(InstanceArn, AccountId, PermissionSetArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAccountAssignments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_account_assignments_input(InstanceArn = InstanceArn, AccountId = AccountId, PermissionSetArn = PermissionSetArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssoadmin$list_account_assignments_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_account_assignments <- ssoadmin_list_account_assignments

#' Lists all the AWS accounts where the specified permission set is
#' provisioned
#'
#' @description
#' Lists all the AWS accounts where the specified permission set is provisioned.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_accounts_for_provisioned_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_list_accounts_for_provisioned_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the PermissionSet from which the associated AWS accounts will
#' be listed.
#' @param ProvisioningStatus The permission set provisioning status for an AWS account.
#' @param MaxResults The maximum number of results to display for the PermissionSet.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_accounts_for_provisioned_permission_set
ssoadmin_list_accounts_for_provisioned_permission_set <- function(InstanceArn, PermissionSetArn, ProvisioningStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAccountsForProvisionedPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_accounts_for_provisioned_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, ProvisioningStatus = ProvisioningStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssoadmin$list_accounts_for_provisioned_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_accounts_for_provisioned_permission_set <- ssoadmin_list_accounts_for_provisioned_permission_set

#' Lists all customer managed policies attached to a specified
#' PermissionSet
#'
#' @description
#' Lists all customer managed policies attached to a specified PermissionSet.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_customer_managed_policy_references_in_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_list_customer_managed_policy_references_in_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param PermissionSetArn &#91;required&#93; The ARN of the `PermissionSet`.
#' @param MaxResults The maximum number of results to display for the list call.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_custo_manag_polic_refer_in_permi_set
ssoadmin_list_customer_managed_policy_references_in_permission_set <- function(InstanceArn, PermissionSetArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCustomerManagedPolicyReferencesInPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_customer_managed_policy_references_in_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssoadmin$list_customer_managed_policy_references_in_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_customer_managed_policy_references_in_permission_set <- ssoadmin_list_customer_managed_policy_references_in_permission_set

#' Lists the IAM Identity Center instances that the caller has access to
#'
#' @description
#' Lists the IAM Identity Center instances that the caller has access to.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_instances/](https://www.paws-r-sdk.com/docs/ssoadmin_list_instances/) for full documentation.
#'
#' @param MaxResults The maximum number of results to display for the instance.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_instances
ssoadmin_list_instances <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_instances_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssoadmin$list_instances_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_instances <- ssoadmin_list_instances

#' Lists the AWS managed policy that is attached to a specified permission
#' set
#'
#' @description
#' Lists the AWS managed policy that is attached to a specified permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_managed_policies_in_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_list_managed_policies_in_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the PermissionSet whose managed policies will be listed.
#' @param MaxResults The maximum number of results to display for the PermissionSet.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_managed_policies_in_permission_set
ssoadmin_list_managed_policies_in_permission_set <- function(InstanceArn, PermissionSetArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListManagedPoliciesInPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_managed_policies_in_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssoadmin$list_managed_policies_in_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_managed_policies_in_permission_set <- ssoadmin_list_managed_policies_in_permission_set

#' Lists the status of the permission set provisioning requests for a
#' specified IAM Identity Center instance
#'
#' @description
#' Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_permission_set_provisioning_status/](https://www.paws-r-sdk.com/docs/ssoadmin_list_permission_set_provisioning_status/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param MaxResults The maximum number of results to display for the assignment.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#' @param Filter Filters results based on the passed attribute value.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_permission_set_provisioning_status
ssoadmin_list_permission_set_provisioning_status <- function(InstanceArn, MaxResults = NULL, NextToken = NULL, Filter = NULL) {
  op <- new_operation(
    name = "ListPermissionSetProvisioningStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_permission_set_provisioning_status_input(InstanceArn = InstanceArn, MaxResults = MaxResults, NextToken = NextToken, Filter = Filter)
  output <- .ssoadmin$list_permission_set_provisioning_status_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_permission_set_provisioning_status <- ssoadmin_list_permission_set_provisioning_status

#' Lists the PermissionSets in an IAM Identity Center instance
#'
#' @description
#' Lists the PermissionSets in an IAM Identity Center instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_permission_sets/](https://www.paws-r-sdk.com/docs/ssoadmin_list_permission_sets/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#' @param MaxResults The maximum number of results to display for the assignment.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_permission_sets
ssoadmin_list_permission_sets <- function(InstanceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPermissionSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_permission_sets_input(InstanceArn = InstanceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssoadmin$list_permission_sets_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_permission_sets <- ssoadmin_list_permission_sets

#' Lists all the permission sets that are provisioned to a specified AWS
#' account
#'
#' @description
#' Lists all the permission sets that are provisioned to a specified AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_permission_sets_provisioned_to_account/](https://www.paws-r-sdk.com/docs/ssoadmin_list_permission_sets_provisioned_to_account/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param AccountId &#91;required&#93; The identifier of the AWS account from which to list the assignments.
#' @param ProvisioningStatus The status object for the permission set provisioning operation.
#' @param MaxResults The maximum number of results to display for the assignment.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_permission_sets_provisioned_to_account
ssoadmin_list_permission_sets_provisioned_to_account <- function(InstanceArn, AccountId, ProvisioningStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPermissionSetsProvisionedToAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_permission_sets_provisioned_to_account_input(InstanceArn = InstanceArn, AccountId = AccountId, ProvisioningStatus = ProvisioningStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssoadmin$list_permission_sets_provisioned_to_account_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_permission_sets_provisioned_to_account <- ssoadmin_list_permission_sets_provisioned_to_account

#' Lists the tags that are attached to a specified resource
#'
#' @description
#' Lists the tags that are attached to a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/ssoadmin_list_tags_for_resource/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param ResourceArn &#91;required&#93; The ARN of the resource with the tags to be listed.
#' @param NextToken The pagination token for the list API. Initially the value is null. Use
#' the output of previous API calls to make subsequent calls.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_list_tags_for_resource
ssoadmin_list_tags_for_resource <- function(InstanceArn, ResourceArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$list_tags_for_resource_input(InstanceArn = InstanceArn, ResourceArn = ResourceArn, NextToken = NextToken)
  output <- .ssoadmin$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$list_tags_for_resource <- ssoadmin_list_tags_for_resource

#' The process by which a specified permission set is provisioned to the
#' specified target
#'
#' @description
#' The process by which a specified permission set is provisioned to the specified target.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_provision_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_provision_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set.
#' @param TargetId TargetID is an AWS account identifier, typically a 10-12 digit string
#' (For example, 123456789012).
#' @param TargetType &#91;required&#93; The entity type for which the assignment will be created.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_provision_permission_set
ssoadmin_provision_permission_set <- function(InstanceArn, PermissionSetArn, TargetId = NULL, TargetType) {
  op <- new_operation(
    name = "ProvisionPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$provision_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, TargetId = TargetId, TargetType = TargetType)
  output <- .ssoadmin$provision_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$provision_permission_set <- ssoadmin_provision_permission_set

#' Attaches an inline policy to a permission set
#'
#' @description
#' Attaches an inline policy to a permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_put_inline_policy_to_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_put_inline_policy_to_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set.
#' @param InlinePolicy &#91;required&#93; The inline policy to attach to a PermissionSet.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_put_inline_policy_to_permission_set
ssoadmin_put_inline_policy_to_permission_set <- function(InstanceArn, PermissionSetArn, InlinePolicy) {
  op <- new_operation(
    name = "PutInlinePolicyToPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$put_inline_policy_to_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, InlinePolicy = InlinePolicy)
  output <- .ssoadmin$put_inline_policy_to_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$put_inline_policy_to_permission_set <- ssoadmin_put_inline_policy_to_permission_set

#' Attaches an AWS managed or customer managed policy to the specified
#' PermissionSet as a permissions boundary
#'
#' @description
#' Attaches an AWS managed or customer managed policy to the specified PermissionSet as a permissions boundary.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_put_permissions_boundary_to_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_put_permissions_boundary_to_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param PermissionSetArn &#91;required&#93; The ARN of the `PermissionSet`.
#' @param PermissionsBoundary &#91;required&#93; The permissions boundary that you want to attach to a `PermissionSet`.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_put_permissions_boundary_to_permission_set
ssoadmin_put_permissions_boundary_to_permission_set <- function(InstanceArn, PermissionSetArn, PermissionsBoundary) {
  op <- new_operation(
    name = "PutPermissionsBoundaryToPermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$put_permissions_boundary_to_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, PermissionsBoundary = PermissionsBoundary)
  output <- .ssoadmin$put_permissions_boundary_to_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$put_permissions_boundary_to_permission_set <- ssoadmin_put_permissions_boundary_to_permission_set

#' Associates a set of tags with a specified resource
#'
#' @description
#' Associates a set of tags with a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_tag_resource/](https://www.paws-r-sdk.com/docs/ssoadmin_tag_resource/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param ResourceArn &#91;required&#93; The ARN of the resource with the tags to be listed.
#' @param Tags &#91;required&#93; A set of key-value pairs that are used to manage the resource.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_tag_resource
ssoadmin_tag_resource <- function(InstanceArn, ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$tag_resource_input(InstanceArn = InstanceArn, ResourceArn = ResourceArn, Tags = Tags)
  output <- .ssoadmin$tag_resource_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$tag_resource <- ssoadmin_tag_resource

#' Disassociates a set of tags from a specified resource
#'
#' @description
#' Disassociates a set of tags from a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_untag_resource/](https://www.paws-r-sdk.com/docs/ssoadmin_untag_resource/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param ResourceArn &#91;required&#93; The ARN of the resource with the tags to be listed.
#' @param TagKeys &#91;required&#93; The keys of tags that are attached to the resource.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_untag_resource
ssoadmin_untag_resource <- function(InstanceArn, ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$untag_resource_input(InstanceArn = InstanceArn, ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .ssoadmin$untag_resource_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$untag_resource <- ssoadmin_untag_resource

#' Updates the IAM Identity Center identity store attributes that you can
#' use with the IAM Identity Center instance for attributes-based access
#' control (ABAC)
#'
#' @description
#' Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see Attribute-Based Access Control in the *IAM Identity Center User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_update_instance_access_control_attribute_configuration/](https://www.paws-r-sdk.com/docs/ssoadmin_update_instance_access_control_attribute_configuration/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed.
#' @param InstanceAccessControlAttributeConfiguration &#91;required&#93; Updates the attributes for your ABAC configuration.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_update_instanc_access_control_attribu_configu
ssoadmin_update_instance_access_control_attribute_configuration <- function(InstanceArn, InstanceAccessControlAttributeConfiguration) {
  op <- new_operation(
    name = "UpdateInstanceAccessControlAttributeConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$update_instance_access_control_attribute_configuration_input(InstanceArn = InstanceArn, InstanceAccessControlAttributeConfiguration = InstanceAccessControlAttributeConfiguration)
  output <- .ssoadmin$update_instance_access_control_attribute_configuration_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$update_instance_access_control_attribute_configuration <- ssoadmin_update_instance_access_control_attribute_configuration

#' Updates an existing permission set
#'
#' @description
#' Updates an existing permission set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssoadmin_update_permission_set/](https://www.paws-r-sdk.com/docs/ssoadmin_update_permission_set/) for full documentation.
#'
#' @param InstanceArn &#91;required&#93; The ARN of the IAM Identity Center instance under which the operation
#' will be executed. For more information about ARNs, see Amazon Resource
#' Names (ARNs) and AWS Service Namespaces in the *AWS General Reference*.
#' @param PermissionSetArn &#91;required&#93; The ARN of the permission set.
#' @param Description The description of the PermissionSet.
#' @param SessionDuration The length of time that the application user sessions are valid for in
#' the ISO-8601 standard.
#' @param RelayState Used to redirect users within the application during the federation
#' authentication process.
#'
#' @keywords internal
#'
#' @rdname ssoadmin_update_permission_set
ssoadmin_update_permission_set <- function(InstanceArn, PermissionSetArn, Description = NULL, SessionDuration = NULL, RelayState = NULL) {
  op <- new_operation(
    name = "UpdatePermissionSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssoadmin$update_permission_set_input(InstanceArn = InstanceArn, PermissionSetArn = PermissionSetArn, Description = Description, SessionDuration = SessionDuration, RelayState = RelayState)
  output <- .ssoadmin$update_permission_set_output()
  config <- get_config()
  svc <- .ssoadmin$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssoadmin$operations$update_permission_set <- ssoadmin_update_permission_set
