% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_import_key_material}
\alias{kms_import_key_material}
\title{Imports or reimports key material into an existing KMS key that was
created without key material}
\usage{
kms_import_key_material(
  KeyId,
  ImportToken,
  EncryptedKeyMaterial,
  ValidTo = NULL,
  ExpirationModel = NULL
)
}
\arguments{
\item{KeyId}{[required] The identifier of the KMS key that will be associated with the imported
key material. This must be the same KMS key specified in the \code{KeyID}
parameter of the corresponding
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} request.
The \code{Origin} of the KMS key must be \code{EXTERNAL} and its \code{KeyState} must
be \code{PendingImport}.

The KMS key can be a symmetric encryption KMS key, HMAC KMS key,
asymmetric encryption KMS key, or asymmetric signing KMS key, including
a \href{https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html}{multi-Region key}
of any supported type. You cannot perform this operation on a KMS key in
a custom key store, or on a KMS key in a different Amazon Web Services
account.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{ImportToken}{[required] The import token that you received in the response to a previous
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} request. It
must be from the same response that contained the public key that you
used to encrypt the key material.}

\item{EncryptedKeyMaterial}{[required] The encrypted key material to import. The key material must be encrypted
under the public wrapping key that
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} returned,
using the wrapping algorithm that you specified in the same
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} request.}

\item{ValidTo}{The date and time when the imported key material expires. This parameter
is required when the value of the \code{ExpirationModel} parameter is
\code{KEY_MATERIAL_EXPIRES}. Otherwise it is not valid.

The value of this parameter must be a future date and time. The maximum
value is 365 days from the request date.

When the key material expires, KMS deletes the key material from the KMS
key. Without its key material, the KMS key is unusable. To use the KMS
key in cryptographic operations, you must reimport the same key
material.

You cannot change the \code{ExpirationModel} or \code{ValidTo} values for the
current import after the request completes. To change either value, you
must delete
(\code{\link[=kms_delete_imported_key_material]{delete_imported_key_material}}) and
reimport the key material.}

\item{ExpirationModel}{Specifies whether the key material expires. The default is
\code{KEY_MATERIAL_EXPIRES}. For help with this choice, see \href{https://docs.aws.amazon.com/en_us/kms/latest/developerguide/importing-keys.html#importing-keys-expiration}{Setting an expiration time}
in the \emph{Key Management Service Developer Guide}.

When the value of \code{ExpirationModel} is \code{KEY_MATERIAL_EXPIRES}, you must
specify a value for the \code{ValidTo} parameter. When value is
\code{KEY_MATERIAL_DOES_NOT_EXPIRE}, you must omit the \code{ValidTo} parameter.

You cannot change the \code{ExpirationModel} or \code{ValidTo} values for the
current import after the request completes. To change either value, you
must reimport the key material.}
}
\description{
Imports or reimports key material into an existing KMS key that was created without key material. \code{\link[=kms_import_key_material]{import_key_material}} also sets the expiration model and expiration date of the imported key material.

See \url{https://www.paws-r-sdk.com/docs/kms_import_key_material/} for full documentation.
}
\keyword{internal}
