% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssooidc_operations.R
\name{ssooidc_register_client}
\alias{ssooidc_register_client}
\title{Registers a client with IAM Identity Center}
\usage{
ssooidc_register_client(clientName, clientType, scopes = NULL)
}
\arguments{
\item{clientName}{[required] The friendly name of the client.}

\item{clientType}{[required] The type of client. The service supports only \code{public} as a client type.
Anything other than public will be rejected by the service.}

\item{scopes}{The list of scopes that are defined by the client. Upon authorization,
this list is used to restrict permissions when granting an access token.}
}
\description{
Registers a client with IAM Identity Center. This allows clients to initiate device authorization. The output should be persisted for reuse through many authentication requests.

See \url{https://www.paws-r-sdk.com/docs/ssooidc_register_client/} for full documentation.
}
\keyword{internal}
