% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_set_user_mfa_preference}
\alias{cognitoidentityprovider_admin_set_user_mfa_preference}
\title{The user's multi-factor authentication (MFA) preference, including which
MFA options are activated, and if any are preferred}
\usage{
cognitoidentityprovider_admin_set_user_mfa_preference(
  SMSMfaSettings = NULL,
  SoftwareTokenMfaSettings = NULL,
  Username,
  UserPoolId
)
}
\arguments{
\item{SMSMfaSettings}{The SMS text message MFA settings.}

\item{SoftwareTokenMfaSettings}{The time-based one-time password software token MFA settings.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{UserPoolId}{[required] The user pool ID.}
}
\description{
The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_mfa_preference/} for full documentation.
}
\keyword{internal}
