% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_get_violation_details}
\alias{fms_get_violation_details}
\title{Retrieves violations for a resource based on the specified Firewall
Manager policy and Amazon Web Services account}
\usage{
fms_get_violation_details(PolicyId, MemberAccount, ResourceId, ResourceType)
}
\arguments{
\item{PolicyId}{[required] The ID of the Firewall Manager policy that you want the details for. You
can get violation details for the following policy types:
\itemize{
\item DNS Firewall
\item Imported Network Firewall
\item Network Firewall
\item Security group content audit
\item Network ACL
\item Third-party firewall
}}

\item{MemberAccount}{[required] The Amazon Web Services account ID that you want the details for.}

\item{ResourceId}{[required] The ID of the resource that has violations.}

\item{ResourceType}{[required] The resource type. This is in the format shown in the \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html}{Amazon Web Services Resource Types Reference}.
Supported resource types are: \verb{AWS::EC2::Instance},
\verb{AWS::EC2::NetworkInterface}, \verb{AWS::EC2::SecurityGroup},
\verb{AWS::NetworkFirewall::FirewallPolicy}, and \verb{AWS::EC2::Subnet}.}
}
\description{
Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/fms_get_violation_details/} for full documentation.
}
\keyword{internal}
