% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iamrolesanywhere_operations.R
\name{iamrolesanywhere_create_profile}
\alias{iamrolesanywhere_create_profile}
\title{Creates a profile, a list of the roles that Roles Anywhere service is
trusted to assume}
\usage{
iamrolesanywhere_create_profile(
  durationSeconds = NULL,
  enabled = NULL,
  managedPolicyArns = NULL,
  name,
  requireInstanceProperties = NULL,
  roleArns,
  sessionPolicy = NULL,
  tags = NULL
)
}
\arguments{
\item{durationSeconds}{Used to determine how long sessions vended using this profile are valid
for. See the \code{Expiration} section of the \href{https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object}{CreateSession API documentation}
page for more details. In requests, if this value is not provided, the
default value will be 3600.}

\item{enabled}{Specifies whether the profile is enabled.}

\item{managedPolicyArns}{A list of managed policy ARNs that apply to the vended session
credentials.}

\item{name}{[required] The name of the profile.}

\item{requireInstanceProperties}{Specifies whether instance properties are required in temporary
credential requests with this profile.}

\item{roleArns}{[required] A list of IAM roles that this profile can assume in a temporary
credential request.}

\item{sessionPolicy}{A session policy that applies to the trust boundary of the vended
session credentials.}

\item{tags}{The tags to attach to the profile.}
}
\description{
Creates a \emph{profile}, a list of the roles that Roles Anywhere service is trusted to assume. You use profiles to intersect permissions with IAM managed policies.

See \url{https://www.paws-r-sdk.com/docs/iamrolesanywhere_create_profile/} for full documentation.
}
\keyword{internal}
