% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_untag_role}
\alias{iam_untag_role}
\title{Removes the specified tags from the role}
\usage{
iam_untag_role(RoleName, TagKeys)
}
\arguments{
\item{RoleName}{[required] The name of the IAM role from which you want to remove tags.

This parameter accepts (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that consist of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{TagKeys}{[required] A list of key names as a simple array of strings. The tags with matching
keys are removed from the specified role.}
}
\description{
Removes the specified tags from the role. For more information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources} in the \emph{IAM User Guide}.

See \url{https://www.paws-r-sdk.com/docs/iam_untag_role/} for full documentation.
}
\keyword{internal}
