% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_update_automated_discovery_configuration}
\alias{macie2_update_automated_discovery_configuration}
\title{Changes the configuration settings and status of automated sensitive
data discovery for an organization or standalone account}
\usage{
macie2_update_automated_discovery_configuration(
  autoEnableOrganizationMembers = NULL,
  status
)
}
\arguments{
\item{autoEnableOrganizationMembers}{Specifies whether to automatically enable automated sensitive data
discovery for accounts in the organization. Valid values are: ALL
(default), enable it for all existing accounts and new member accounts;
NEW, enable it only for new member accounts; and, NONE, don't enable it
for any accounts.

If you specify NEW or NONE, automated sensitive data discovery continues
to be enabled for any existing accounts that it's currently enabled for.
To enable or disable it for individual member accounts, specify NEW or
NONE, and then enable or disable it for each account by using the
BatchUpdateAutomatedDiscoveryAccounts operation.}

\item{status}{[required] The new status of automated sensitive data discovery for the
organization or account. Valid values are: ENABLED, start or resume all
automated sensitive data discovery activities; and, DISABLED, stop
performing all automated sensitive data discovery activities.

If you specify DISABLED for an administrator account, you also disable
automated sensitive data discovery for all member accounts in the
organization.}
}
\description{
Changes the configuration settings and status of automated sensitive data discovery for an organization or standalone account.

See \url{https://www.paws-r-sdk.com/docs/macie2_update_automated_discovery_configuration/} for full documentation.
}
\keyword{internal}
