% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_update_user_attributes}
\alias{cognitoidentityprovider_admin_update_user_attributes}
\title{This action might generate an SMS text message}
\usage{
cognitoidentityprovider_admin_update_user_attributes(
  UserPoolId,
  Username,
  UserAttributes,
  ClientMetadata = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The ID of the user pool where you want to update user attributes.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{UserAttributes}{[required] An array of name-value pairs representing user attributes.

For custom attributes, you must prepend the \verb{custom:} prefix to the
attribute name.

If your user pool requires verification before Amazon Cognito updates an
attribute value that you specify in this request, Amazon Cognito doesn’t
immediately update the value of that attribute. After your user receives
and responds to a verification message to verify the new value, Amazon
Cognito updates the attribute value. Your user can sign in and receive
messages with the original attribute value until they verify the new
value.

To skip the verification message and update the value of an attribute
that requires verification in the same API request, include the
\code{email_verified} or \code{phone_number_verified} attribute, with a value of
\code{true}. If you set the \code{email_verified} or \code{phone_number_verified} value
for an \code{email} or \code{phone_number} attribute that requires verification to
\code{true}, Amazon Cognito doesn’t send a verification message to your user.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the AdminUpdateUserAttributes API action, Amazon
Cognito invokes the function that is assigned to the \emph{custom message}
trigger. When Amazon Cognito invokes this function, it passes a JSON
payload, which the function receives as input. This payload contains a
\code{clientMetadata} attribute, which provides the data that you assigned to
the ClientMetadata parameter in your AdminUpdateUserAttributes request.
In your function code in Lambda, you can process the \code{clientMetadata}
value to enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-working-with-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the \code{ClientMetadata} parameter, note that Amazon Cognito
won't do the following:
\itemize{
\item Store the \code{ClientMetadata} value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the \code{ClientMetadata} parameter serves no purpose.
\item Validate the \code{ClientMetadata} value.
\item Encrypt the \code{ClientMetadata} value. Don't send sensitive information
in this parameter.
}}
}
\description{
This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_user_attributes/} for full documentation.
}
\keyword{internal}
