% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_policy}
\alias{s3_put_bucket_policy}
\title{Replaces a policy on a bucket}
\usage{
s3_put_bucket_policy(Bucket, ContentMD5, ConfirmRemoveSelfBucketAccess,
  Policy)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{}

\item{ConfirmRemoveSelfBucketAccess}{Set this parameter to true to confirm that you want to remove your
permissions to change this bucket policy in the future.}

\item{Policy}{[required] The bucket policy as a JSON document.}
}
\description{
Replaces a policy on a bucket. If the bucket already has a policy, the
one in this request completely replaces it.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_policy(
  Bucket = "string",
  ContentMD5 = "string",
  ConfirmRemoveSelfBucketAccess = TRUE|FALSE,
  Policy = "string"
)
}
}

\examples{
# The following example sets a permission policy on a bucket.
\donttest{svc$put_bucket_policy(
  Bucket = "examplebucket",
  Policy = "{\\"Version\\": \\"2012-10-17\\", \\"Statement\\": [{ \\"Sid\\": \\"id-1\\",\\"Effect\\": ..."
)}

}
\keyword{internal}
