% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_smb_security_strategy}
\alias{storagegateway_update_smb_security_strategy}
\title{Updates the SMB security strategy on a file gateway}
\usage{
storagegateway_update_smb_security_strategy(GatewayARN,
  SMBSecurityStrategy)
}
\arguments{
\item{GatewayARN}{[required]}

\item{SMBSecurityStrategy}{[required] Specifies the type of security strategy.

ClientSpecified: if you use this option, requests are established based
on what is negotiated by the client. This option is recommended when you
want to maximize compatibility across different clients in your
environment.

MandatorySigning: if you use this option, file gateway only allows
connections from SMBv2 or SMBv3 clients that have signing enabled. This
option works with SMB clients on Microsoft Windows Vista, Windows Server
2008 or newer.

MandatoryEncryption: if you use this option, file gateway only allows
connections from SMBv3 clients that have encryption enabled. This option
is highly recommended for environments that handle sensitive data. This
option works with SMB clients on Microsoft Windows 8, Windows Server
2012 or newer.}
}
\description{
Updates the SMB security strategy on a file gateway. This action is only
supported in file gateways.

This API is called Security level in the User Guide.

A higher security level can affect performance of the gateway.
}
\section{Request syntax}{
\preformatted{svc$update_smb_security_strategy(
  GatewayARN = "string",
  SMBSecurityStrategy = "ClientSpecified"|"MandatorySigning"|"MandatoryEncryption"
)
}
}

\keyword{internal}
