% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_smb_file_shares}
\alias{storagegateway_describe_smb_file_shares}
\title{Gets a description for one or more Server Message Block (SMB) file
shares from a file gateway}
\usage{
storagegateway_describe_smb_file_shares(FileShareARNList)
}
\arguments{
\item{FileShareARNList}{[required] An array containing the Amazon Resource Name (ARN) of each file share to
be described.}
}
\value{
A list with the following syntax:\preformatted{list(
  SMBFileShareInfoList = list(
    list(
      FileShareARN = "string",
      FileShareId = "string",
      FileShareStatus = "string",
      GatewayARN = "string",
      KMSEncrypted = TRUE|FALSE,
      KMSKey = "string",
      Path = "string",
      Role = "string",
      LocationARN = "string",
      DefaultStorageClass = "string",
      ObjectACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"|"aws-exec-read",
      ReadOnly = TRUE|FALSE,
      GuessMIMETypeEnabled = TRUE|FALSE,
      RequesterPays = TRUE|FALSE,
      SMBACLEnabled = TRUE|FALSE,
      AccessBasedEnumeration = TRUE|FALSE,
      AdminUserList = list(
        "string"
      ),
      ValidUserList = list(
        "string"
      ),
      InvalidUserList = list(
        "string"
      ),
      AuditDestinationARN = "string",
      Authentication = "string",
      CaseSensitivity = "ClientSpecified"|"CaseSensitive",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      ),
      FileShareName = "string",
      CacheAttributes = list(
        CacheStaleTimeoutInSeconds = 123
      ),
      NotificationPolicy = "string"
    )
  )
)
}
}
\description{
Gets a description for one or more Server Message Block (SMB) file
shares from a file gateway. This operation is only supported for file
gateways.
}
\section{Request syntax}{
\preformatted{svc$describe_smb_file_shares(
  FileShareARNList = list(
    "string"
  )
)
}
}

\keyword{internal}
