% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_object_versions}
\alias{s3_list_object_versions}
\title{Returns metadata about all of the versions of objects in a bucket}
\usage{
s3_list_object_versions(Bucket, Delimiter, EncodingType, KeyMarker,
  MaxKeys, Prefix, VersionIdMarker)
}
\arguments{
\item{Bucket}{[required]}

\item{Delimiter}{A delimiter is a character you use to group keys.}

\item{EncodingType}{}

\item{KeyMarker}{Specifies the key to start with when listing objects in a bucket.}

\item{MaxKeys}{Sets the maximum number of keys returned in the response. The response
might contain fewer keys but will never contain more.}

\item{Prefix}{Limits the response to keys that begin with the specified prefix.}

\item{VersionIdMarker}{Specifies the object version you want to start listing from.}
}
\description{
Returns metadata about all of the versions of objects in a bucket.
}
\section{Request syntax}{
\preformatted{svc$list_object_versions(
  Bucket = "string",
  Delimiter = "string",
  EncodingType = "url",
  KeyMarker = "string",
  MaxKeys = 123,
  Prefix = "string",
  VersionIdMarker = "string"
)
}
}

\examples{
# The following example return versions of an object with specific key
# name prefix. The request limits the number of items returned to two. If
# there are are more than two object version, S3 returns NextToken in the
# response. You can specify this token value in your next request to fetch
# next set of object versions.
\donttest{svc$list_object_versions(
  Bucket = "examplebucket",
  Prefix = "HappyFace.jpg"
)}

}
\keyword{internal}
