% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_object_acl}
\alias{s3_get_object_acl}
\title{Returns the access control list (ACL) of an object}
\usage{
s3_get_object_acl(Bucket, Key, VersionId, RequestPayer)
}
\arguments{
\item{Bucket}{[required] The bucket name that contains the object for which to get the ACL
information.

When using this API with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this operation using an access point through the AWS SDKs,
you provide the access point ARN in place of the bucket name. For more
information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html}{Using Access Points}
in the \emph{Amazon Simple Storage Service Developer Guide}.}

\item{Key}{[required] The key of the object for which to get the ACL information.}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{RequestPayer}{}
}
\description{
Returns the access control list (ACL) of an object. To use this
operation, you must have READ\\_ACP access to the object.
}
\details{
\strong{Versioning}

By default, GET returns ACL information about the current version of an
object. To return ACL information about a different version, use the
versionId subresource.

The following operations are related to \code{GetObjectAcl}:
\itemize{
\item GetObject
\item DeleteObject
\item PutObject
}
}
\section{Request syntax}{
\preformatted{svc$get_object_acl(
  Bucket = "string",
  Key = "string",
  VersionId = "string",
  RequestPayer = "requester"
)
}
}

\examples{
\dontrun{
# The following example retrieves access control list (ACL) of an object.
svc$get_object_acl(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg"
)
}

}
\keyword{internal}
