% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_list_jobs}
\alias{glacier_list_jobs}
\title{This operation lists jobs for a vault, including jobs that are
in-progress and jobs that have recently finished}
\usage{
glacier_list_jobs(accountId, vaultName, limit, marker, statuscode,
  completed)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
\'\code{-}\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
ID associated with the credentials used to sign the request. If you use
an account ID, do not include any hyphens (\'-\') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{limit}{The maximum number of jobs to be returned. The default limit is 50. The
number of jobs returned might be fewer than the specified limit, but the
number of returned jobs never exceeds the limit.}

\item{marker}{An opaque string used for pagination. This value specifies the job at
which the listing of jobs should begin. Get the marker value from a
previous List Jobs response. You only need to include the marker if you
are continuing the pagination of results started in a previous List Jobs
request.}

\item{statuscode}{The type of job status to return. You can specify the following values:
\code{InProgress}, \code{Succeeded}, or \code{Failed}.}

\item{completed}{The state of the jobs to return. You can specify \code{true} or \code{false}.}
}
\description{
This operation lists jobs for a vault, including jobs that are
in-progress and jobs that have recently finished. The List Job operation
returns a list of these jobs sorted by job initiation time.
}
\details{
Amazon Glacier retains recently completed jobs for a period before
deleting them; however, it eventually removes completed jobs. The output
of completed jobs can be retrieved. Retaining completed jobs for a
period of time after they have completed enables you to get a job output
in the event you miss the job completion notification or your first
attempt to download it fails. For example, suppose you start an archive
retrieval job to download an archive. After the job completes, you start
to download the archive but encounter a network error. In this scenario,
you can retry and download the archive while the job exists.

The List Jobs operation supports pagination. You should always check the
response \code{Marker} field. If there are no more jobs to list, the \code{Marker}
field is set to \code{null}. If there are more jobs to list, the \code{Marker}
field is set to a non-null value, which you can use to continue the
pagination of the list. To return a list of jobs that begins at a
specific job, set the marker request parameter to the \code{Marker} value for
that job that you obtained from a previous List Jobs request.

You can set a maximum limit for the number of jobs returned in the
response by specifying the \code{limit} parameter in the request. The default
limit is 50. The number of jobs returned might be fewer than the limit,
but the number of returned jobs never exceeds the limit.

Additionally, you can filter the jobs list returned by specifying the
optional \code{statuscode} parameter or \code{completed} parameter, or both. Using
the \code{statuscode} parameter, you can specify to return only jobs that
match either the \code{InProgress}, \code{Succeeded}, or \code{Failed} status. Using
the \code{completed} parameter, you can specify to return only jobs that were
completed (\code{true}) or jobs that were not completed (\code{false}).

For more information about using this operation, see the documentation
for the underlying REST API \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html}{List Jobs}.
}
\section{Request syntax}{
\preformatted{svc$list_jobs(
  accountId = "string",
  vaultName = "string",
  limit = "string",
  marker = "string",
  statuscode = "string",
  completed = "string"
)
}
}

\examples{
\dontrun{
# The example lists jobs for the vault named my-vault.
svc$list_jobs(
  accountId = "-",
  vaultName = "my-vault"
)
}

}
\keyword{internal}
