% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspacedata_operations.R
\name{finspacedata_update_dataset}
\alias{finspacedata_update_dataset}
\title{Updates a FinSpace Dataset}
\usage{
finspacedata_update_dataset(
  clientToken = NULL,
  datasetId,
  datasetTitle,
  kind,
  datasetDescription = NULL,
  alias = NULL,
  schemaDefinition = NULL
)
}
\arguments{
\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{datasetId}{[required] The unique identifier for the Dataset to update.}

\item{datasetTitle}{[required] A display title for the Dataset.}

\item{kind}{[required] The format in which the Dataset data is structured.
\itemize{
\item \code{TABULAR} – Data is structured in a tabular format.
\item \code{NON_TABULAR} – Data is structured in a non-tabular format.
}}

\item{datasetDescription}{A description for the Dataset.}

\item{alias}{The unique resource identifier for a Dataset.}

\item{schemaDefinition}{Definition for a schema on a tabular Dataset.}
}
\description{
Updates a FinSpace Dataset.

See \url{https://paws-r.github.io/docs/finspacedata/update_dataset.html} for full documentation.
}
\keyword{internal}
