% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_legal_hold}
\alias{s3_put_object_legal_hold}
\title{Applies a legal hold configuration to the specified object}
\usage{
s3_put_object_legal_hold(
  Bucket,
  Key,
  LegalHold = NULL,
  RequestPayer = NULL,
  VersionId = NULL,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name containing the object that you want to place a legal
hold on.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.}

\item{Key}{[required] The key name for the object that you want to place a legal hold on.}

\item{LegalHold}{Container element for the legal hold configuration you want to apply to
the specified object.}

\item{RequestPayer}{}

\item{VersionId}{The version ID of the object that you want to place a legal hold on.}

\item{ContentMD5}{The MD5 hash for the request body.

For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
using the SDK. This header will not provide any additional functionality
if not using the SDK. When sending this header, there must be a
corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Applies a legal hold configuration to the specified object. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html}{Locking Objects}.

See \url{https://paws-r.github.io/docs/s3/put_object_legal_hold.html} for full documentation.
}
\keyword{internal}
