% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_logically_air_gapped_backup_vault}
\alias{backup_create_logically_air_gapped_backup_vault}
\title{This request creates a logical container to where backups may be copied}
\usage{
backup_create_logically_air_gapped_backup_vault(
  BackupVaultName,
  BackupVaultTags = NULL,
  CreatorRequestId = NULL,
  MinRetentionDays,
  MaxRetentionDays
)
}
\arguments{
\item{BackupVaultName}{[required] This is the name of the vault that is being created.}

\item{BackupVaultTags}{These are the tags that will be included in the newly-created vault.}

\item{CreatorRequestId}{This is the ID of the creation request.

This parameter is optional. If used, this parameter must contain 1 to 50
alphanumeric or '-_.' characters.}

\item{MinRetentionDays}{[required] This setting specifies the minimum retention period that the vault
retains its recovery points. If this parameter is not specified, no
minimum retention period is enforced.

If specified, any backup or copy job to the vault must have a lifecycle
policy with a retention period equal to or longer than the minimum
retention period. If a job retention period is shorter than that minimum
retention period, then the vault fails the backup or copy job, and you
should either modify your lifecycle settings or use a different vault.}

\item{MaxRetentionDays}{[required] This is the setting that specifies the maximum retention period that the
vault retains its recovery points. If this parameter is not specified,
Backup does not enforce a maximum retention period on the recovery
points in the vault (allowing indefinite storage).

If specified, any backup or copy job to the vault must have a lifecycle
policy with a retention period equal to or shorter than the maximum
retention period. If the job retention period is longer than that
maximum retention period, then the vault fails the backup or copy job,
and you should either modify your lifecycle settings or use a different
vault.}
}
\description{
This request creates a logical container to where backups may be copied.

See \url{https://www.paws-r-sdk.com/docs/backup_create_logically_air_gapped_backup_vault/} for full documentation.
}
\keyword{internal}
