% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{globalaccelerator}
\alias{globalaccelerator}
\title{AWS Global Accelerator}
\usage{
globalaccelerator(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
This is the \emph{AWS Global Accelerator API Reference}. This guide is for
developers who need detailed information about AWS Global Accelerator
API actions, data types, and errors. For more information about Global
Accelerator features, see the \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/Welcome.html}{AWS Global Accelerator Developer Guide}.

AWS Global Accelerator is a network layer service in which you create
accelerators to improve availability and performance for internet
applications used by a global audience.

You must specify the US-West-2 (Oregon) Region to create or update
accelerators.

Global Accelerator provides you with static IP addresses that you
associate with your accelerator. These IP addresses are anycast from the
AWS edge network and distribute incoming application traffic across
multiple endpoint resources in multiple AWS Regions, which increases the
availability of your applications. Endpoints can be Elastic IP
addresses, Network Load Balancers, and Application Load Balancers that
are located in one AWS Region or multiple Regions.

Global Accelerator uses the AWS global network to route traffic to the
optimal regional endpoint based on health, client location, and policies
that you configure. The service reacts instantly to changes in health or
configuration to ensure that internet traffic from clients is directed
to only healthy endpoints.

Global Accelerator includes components that work together to help you
improve performance and availability for your applications:

Static IP address

:   AWS Global Accelerator provides you with a set of static IP
addresses which are anycast from the AWS edge network and serve as
the single fixed entry points for your clients. If you already have
Elastic Load Balancing or Elastic IP address resources set up for
your applications, you can easily add those to Global Accelerator to
allow the resources to be accessed by a Global Accelerator static IP
address.

Accelerator

:   An accelerator directs traffic to optimal endpoints over the AWS
global network to improve availability and performance for your
internet applications that have a global audience. Each accelerator
includes one or more listeners.

Network zone

:   A network zone services the static IP addresses for your accelerator
from a unique IP subnet. Similar to an AWS Availability Zone, a
network zone is an isolated unit with its own set of physical
infrastructure. When you configure an accelerator, Global
Accelerator allocates two IPv4 addresses for it. If one IP address
from a network zone becomes unavailable due to IP address blocking
by certain client networks, or network disruptions, then client
applications can retry on the healthy static IP address from the
other isolated network zone.

Listener

:   A listener processes inbound connections from clients to Global
Accelerator, based on the protocol and port that you configure. Each
listener has one or more endpoint groups associated with it, and
traffic is forwarded to endpoints in one of the groups. You
associate endpoint groups with listeners by specifying the Regions
that you want to distribute traffic to. Traffic is distributed to
optimal endpoints within the endpoint groups associated with a
listener.

Endpoint group

:   Each endpoint group is associated with a specific AWS Region.
Endpoint groups include one or more endpoints in the Region. You can
increase or reduce the percentage of traffic that would be otherwise
directed to an endpoint group by adjusting a setting called a
\emph{traffic dial}. The traffic dial lets you easily do performance
testing or blue/green deployment testing for new releases across
different AWS Regions, for example.

Endpoint

:   An endpoint is an Elastic IP address, Network Load Balancer, or
Application Load Balancer. Traffic is routed to endpoints based on
several factors, including the geo-proximity to the user, the health
of the endpoint, and the configuration options that you choose, such
as endpoint weights. For each endpoint, you can configure weights,
which are numbers that you can use to specify the proportion of
traffic to route to each one. This can be useful, for example, to do
performance testing within a Region.
}
\section{Service syntax}{
\preformatted{svc <- globalaccelerator(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=globalaccelerator_create_accelerator]{create_accelerator} \tab Create an accelerator \cr
\link[=globalaccelerator_create_endpoint_group]{create_endpoint_group} \tab Create an endpoint group for the specified listener \cr
\link[=globalaccelerator_create_listener]{create_listener} \tab Create a listener to process inbound connections from clients to an accelerator\cr
\link[=globalaccelerator_delete_accelerator]{delete_accelerator} \tab Delete an accelerator \cr
\link[=globalaccelerator_delete_endpoint_group]{delete_endpoint_group} \tab Delete an endpoint group from a listener \cr
\link[=globalaccelerator_delete_listener]{delete_listener} \tab Delete a listener from an accelerator \cr
\link[=globalaccelerator_describe_accelerator]{describe_accelerator} \tab Describe an accelerator \cr
\link[=globalaccelerator_describe_accelerator_attributes]{describe_accelerator_attributes} \tab Describe the attributes of an accelerator \cr
\link[=globalaccelerator_describe_endpoint_group]{describe_endpoint_group} \tab Describe an endpoint group \cr
\link[=globalaccelerator_describe_listener]{describe_listener} \tab Describe a listener \cr
\link[=globalaccelerator_list_accelerators]{list_accelerators} \tab List the accelerators for an AWS account \cr
\link[=globalaccelerator_list_endpoint_groups]{list_endpoint_groups} \tab List the endpoint groups that are associated with a listener \cr
\link[=globalaccelerator_list_listeners]{list_listeners} \tab List the listeners for an accelerator \cr
\link[=globalaccelerator_update_accelerator]{update_accelerator} \tab Update an accelerator \cr
\link[=globalaccelerator_update_accelerator_attributes]{update_accelerator_attributes} \tab Update the attributes for an accelerator \cr
\link[=globalaccelerator_update_endpoint_group]{update_endpoint_group} \tab Update an endpoint group \cr
\link[=globalaccelerator_update_listener]{update_listener} \tab Update a listener
}
}

\examples{
\donttest{svc <- globalaccelerator()
svc$create_accelerator(
  Foo = 123
)}

}
