% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{elasticinference}
\alias{elasticinference}
\title{Amazon Elastic  Inference}
\usage{
elasticinference(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Elastic Inference public APIs.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- elasticinference(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.machine.learning:elasticinference_describe_accelerator_offerings]{describe_accelerator_offerings} \tab Describes the locations in which a given accelerator type or set of types is present in a given region\cr
\link[paws.machine.learning:elasticinference_describe_accelerators]{describe_accelerators} \tab Describes information over a provided set of accelerators belonging to an account\cr
\link[paws.machine.learning:elasticinference_describe_accelerator_types]{describe_accelerator_types} \tab Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput\cr
\link[paws.machine.learning:elasticinference_list_tags_for_resource]{list_tags_for_resource} \tab Returns all tags of an Elastic Inference Accelerator\cr
\link[paws.machine.learning:elasticinference_tag_resource]{tag_resource} \tab Adds the specified tags to an Elastic Inference Accelerator\cr
\link[paws.machine.learning:elasticinference_untag_resource]{untag_resource} \tab Removes the specified tags from an Elastic Inference Accelerator
}
}

\examples{
\dontrun{
svc <- elasticinference()
svc$describe_accelerator_offerings(
  Foo = 123
)
}

}
