% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_arithmetic.R
\docType{methods}
\name{arithmetic}
\alias{*,ddmatrix,ddmatrix-method}
\alias{*,ddmatrix,numeric-method}
\alias{*,numeric,ddmatrix-method}
\alias{+,ddmatrix,ddmatrix-method}
\alias{+,ddmatrix,numeric-method}
\alias{+,numeric,ddmatrix-method}
\alias{-,ddmatrix,ddmatrix-method}
\alias{-,ddmatrix,missing-method}
\alias{-,ddmatrix,numeric-method}
\alias{-,numeric,ddmatrix-method}
\alias{/,ddmatrix,ddmatrix-method}
\alias{/,ddmatrix,numeric-method}
\alias{/,numeric,ddmatrix-method}
\alias{\%/\%,ddmatrix,ddmatrix-method}
\alias{\%/\%,ddmatrix,numeric-method}
\alias{\%/\%,numeric,ddmatrix-method}
\alias{\%\%,ddmatrix,ddmatrix-method}
\alias{\%\%,ddmatrix,numeric-method}
\alias{\%\%,numeric,ddmatrix-method}
\alias{^,ddmatrix,ddmatrix-method}
\alias{^,ddmatrix,numeric-method}
\alias{arithmetic}
\title{Arithmetic Operators}
\usage{
\S4method{+}{ddmatrix,numeric}(e1, e2)

\S4method{+}{numeric,ddmatrix}(e1, e2)

\S4method{+}{ddmatrix,ddmatrix}(e1, e2)

\S4method{-}{ddmatrix,numeric}(e1, e2)

\S4method{-}{numeric,ddmatrix}(e1, e2)

\S4method{-}{ddmatrix,ddmatrix}(e1, e2)

\S4method{-}{ddmatrix,missing}(e1, e2)

\S4method{*}{ddmatrix,numeric}(e1, e2)

\S4method{*}{numeric,ddmatrix}(e1, e2)

\S4method{*}{ddmatrix,ddmatrix}(e1, e2)

\S4method{/}{ddmatrix,numeric}(e1, e2)

\S4method{/}{numeric,ddmatrix}(e1, e2)

\S4method{/}{ddmatrix,ddmatrix}(e1, e2)

\S4method{^}{ddmatrix,numeric}(e1, e2)

\S4method{^}{ddmatrix,ddmatrix}(e1, e2)

\S4method{\%\%}{ddmatrix,ddmatrix}(e1, e2)

\S4method{\%\%}{ddmatrix,numeric}(e1, e2)

\S4method{\%\%}{numeric,ddmatrix}(e1, e2)

\S4method{\%/\%}{ddmatrix,ddmatrix}(e1, e2)

\S4method{\%/\%}{numeric,ddmatrix}(e1, e2)

\S4method{\%/\%}{ddmatrix,numeric}(e1, e2)
}
\arguments{
\item{e1, e2}{numeric distributed matrices or numeric vectors}
}
\value{
Returns a distributed matrix.
}
\description{
Binary operations for distributed matrix/distributed matrix and distributed
matrix/vector operations.
}
\details{
If \code{e1} and \code{e2} are distributed matrices, then they must be
conformable, on the same BLACS context, and have the same blocking
dimension.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix(1:9, 3, bldim=2)

y <- (2*x) - x^(.5)
print(y)

finalize()
}

}
\keyword{Methods}

