% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_eigen2.r
\name{eigen2}
\alias{eigen2}
\title{eigen2}
\usage{
eigen2(x, range = c(-Inf, Inf), range.type = "interval",
  only.values = FALSE, abstol = 1e-08, orfac = 0.001)
}
\arguments{
\item{x}{symmetric, numeric ddmatrix.}

\item{range}{A set of interval endpoints, i.e. a numeric pair.  Controls the
set of values over which the eigenvalue search occurs.}

\item{range.type}{Controls whether interval \code{range} refers to a set of
possible values for the eigenvalues, or a set of indices for the
eigenvalues.  Options are "interval" and "index".}

\item{only.values}{logical. Determines whether only the eigenvalues should
be computed, or if the eigenvectors should as well.}

\item{abstol}{The absolute error tolerance for the eigenvalues.}

\item{orfac}{Specifies which eigenvectors should be reorthogonalized.
Eigenvectors that correspond to eigenvalues which are within
tol=orfac*norm(A)of each other are to be reorthogonalized.}
}
\value{
Returns a distributed matrix.
}
\description{
Compute eigenvalues and, optionally, eigenvectors of a real symmetric matrix
by seraching over ranges of values or ranges of indices.
}
\details{
This new method computes selected eigenvalues and, optionally, eigenvectors
of a real symmetric matrix. Eigenvalues and eigenvectors can be selected by
specifying either a range of values or a range of indices for the desired
eigenvalues.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()
init.grid()

comm.set.seed(seed=1234, diff=TRUE)

x <- crossprod(ddmatrix("rnorm", 10, 3, bldim=2))
y <- as.matrix(x)

comm.print(eigen(y))

### Look for eigenvalues in the range 0 to 10
ev <- eigen2(x, range=c(0, 10), only.values=TRUE)
comm.print(ev)

finalize()
}

}
\keyword{Algebra}
\keyword{Linear}
\keyword{Methods}

