% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_zmq_transfer.r
\name{File Transfer Functions}
\alias{File Transfer Functions}
\alias{zmq.sendfile}
\alias{zmq.recvfile}
\title{File Transfer Functions}
\usage{
zmq.sendfile(port, filename, verbose = FALSE, flags = .pbd_env$ZMQ.SR$BLOCK)

zmq.recvfile(port, endpoint, filename, verbose = FALSE,
  flags = .pbd_env$ZMQ.SR$BLOCK)
}
\arguments{
\item{port}{A valid tcp port.}

\item{filename}{The name (as a string) of the in/out files.}

\item{verbose}{logical; determines if a progress bar should be shown.}

\item{flags}{a flag for the method used by \code{zmq_sendfile} and
\code{zmq_recvfile}}

\item{endpoint}{A ZMQ socket endpoint.}
}
\value{
\code{zmq.sendfile()} and \code{zmq.recvfile()} return
number of bytes (invisible) in the sent message if successful,
otherwise returns -1 (invisible) and sets \code{errno} to the error
value, see ZeroMQ manual for details.
}
\description{
High level functions calling \code{zmq_send()} and \code{zmq_recv()}
to transfer a file in 200 KiB chunks.
}
\details{
\code{zmq.sendfile()} binds a \code{ZMQ_PUSH} socket, and 
\code{zmq.recvfile()} connects to this with a \code{ZMQ_PULL} socket.
}
\examples{
\dontrun{
### Run the sender and receiver code in separate R sessions.

# Receiver
library(pbdZMQ, quietly = TRUE)
zmq.recvfile(55555, "localhost", "/tmp/outfile", verbose=TRUE)

# Sender
library(pbdZMQ, quietly = TRUE)
zmq.sendfile(55555, "/tmp/infile", verbose=TRUE)
}

}
\references{
ZeroMQ/4.1.0 API Reference:
\url{http://api.zeromq.org/4-1:_start}

Programming with Big Data in R Website: \url{http://r-pbd.org/}
}
\seealso{
\code{\link{zmq.msg.send}()}, \code{\link{zmq.msg.recv}()}.
}
\author{
Drew Schmidt and Christian Heckendorf
}
\keyword{programming}
