% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rv.triCC}
\alias{rv.triCC}
\title{The index of the CC-vertex region in a triangle that contains a point}
\usage{
rv.triCC(p, tri)
}
\arguments{
\item{p}{A 2D point for which CC-vertex region it resides in is to be determined in the
triangle \code{tri}}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}
}
\value{
A list with two elements
\item{rv}{Index of the CC-vertex region that contains point, \code{p} in the triangle \code{tri}}
\item{tri}{The vertices of the triangle, where row number corresponds to the vertex index in \code{rv}.}
}
\description{
Returns the index of the vertex whose region contains point \code{p} in
a triangle \code{tri}=\eqn{(A,B,C)} and vertex regions are based on the circumcenter CC of \code{tri}.
(see the plots in the example for illustrations).

The vertices of the  triangle \code{tri} are labeled as
1=A,2=B, and 3=C also according to the row number the vertex is recorded in \code{tri}.
If the point, \code{p}, is not inside \code{tri}, then the function yields \code{NA} as output.
The corresponding vertex region is the polygon whose interior points are closest to that vertex.
If \code{tri} is equilateral triangle, then CC and CM (center of mass) coincide.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

P<-c(1.3,1.2)
rv.triCC(P,Tr)

P<-c(1.8,.5)
rv.triCC(P,Tr)

P<-c(1.6,1.4)
rv.triCC(P,Tr)

P<-c(.5,.8)
rv.triCC(P,Tr)

CC<-circ.cent.tri(Tr)  #the circumcenter
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],CC[1])
Ylim<-range(Tr[,2],CC[2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,asp=1,xlab="",ylab="",pch=".",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tr,CC,Ds)
xc<-txt[,1]+c(-.07,.08,.06,.12,-.1,-.1,-.09)
yc<-txt[,2]+c(.02,-.02,.03,.0,.02,.06,-.04)
txt.str<-c("A","B","C","CC","D1","D2","D3")
text(xc,yc,txt.str)

RV1<-(A+.5*(D3-A)+A+.5*(D2-A))/2
RV2<-(B+.5*(D3-B)+B+.5*(D1-B))/2
RV3<-(C+.5*(D2-C)+C+.5*(D1-C))/2

txt<-rbind(RV1,RV2,RV3)
xc<-txt[,1]
yc<-txt[,2]
txt.str<-c("rv=1","rv=2","rv=3")
text(xc,yc,txt.str)

n<-10  #try also n<-20
dat<-runif.tri(n,Tr)$g

Rv<-vector()
for (i in 1:n)
  Rv<-c(Rv,rv.triCC(dat[i,],Tr)$rv)
Rv

Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,asp=1,xlab="",ylab="",pch=".",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=".")
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
text(dat,labels=factor(Rv))

txt<-rbind(Tr,CC,Ds)
xc<-txt[,1]+c(-.07,.08,.06,.12,-.1,-.1,-.09)
yc<-txt[,2]+c(.02,-.02,.03,.0,.02,.06,-.04)
txt.str<-c("A","B","C","CC","D1","D2","D3")
text(xc,yc,txt.str)

P<-c(1.3,1.2)
rv.triCC(P,Tr)

dat.fr<-data.frame(a=Tr)
rv.triCC(P,dat.fr)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rv.tri.cent}}, \code{\link{rv.triCM}}, \code{\link{rv.bastriCM}},
\code{\link{rv.bastriCC}}, \code{\link{rv.bastri.cent}}, and \code{\link{rvTeCM}}
}
