% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rverts.triCC}
\alias{rverts.triCC}
\title{The indices of the CC-vertex regions in a triangle that contains the points in a give data set.}
\usage{
rverts.triCC(Dt, tri)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points for which indices of the vertex regions
containing them are to be determined.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}
}
\value{
A list with two elements
\item{rv}{Indices (i.e., a vector of indices) of the vertices whose region contains points in \code{Dt}
in the triangle \code{tri}}
\item{tri}{The vertices of the triangle, where row number corresponds to the vertex index in \code{rv}.}
}
\description{
Returns the indices of the vertices whose regions contain the points in data set \code{Dt} in
a triangle \code{tri}=\eqn{(A,B,C)} and vertex regions are based on the circumcenter CC of \code{tri}.
(see the plots in the example for illustrations).

The vertices of the  triangle \code{tri} are labeled as
1=A,2=B, and 3=C also according to the row number the vertex is recorded in \code{tri}.
If a point in \code{Dt} is not inside \code{tri}, then the function yields \code{NA} as output.
The corresponding vertex region is the polygon whose interior points are closest to that vertex.
If \code{tri} is equilateral triangle, then CC and CM (center of mass) coincide.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

P<-c(.4,.2)
rverts.triCC(P,Tr)

P<-c(1.8,.5)
rverts.triCC(P,Tr)

P<-c(10.5,1.6)
rverts.triCC(P,Tr)

n<-10  #try also n<-20
set.seed(1)
dat<-runif.tri(n,Tr)$g

rverts.triCC(dat,Tr)
rverts.triCC(rbind(dat,c(2,2)),Tr)

rv<-rverts.triCC(dat,Tr)
rv

CC<-circ.cent.tri(Tr)
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],dat[,1],CC[1])
Ylim<-range(Tr[,2],dat[,2],CC[2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",asp=1,xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=".",col=1)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

xc<-Tr[,1]
yc<-Tr[,2]
txt.str<-c("rv=1","rv=2","rv=3")
text(xc,yc,txt.str)

txt<-rbind(CC,Ds)
xc<-txt[,1]+c(.04,.04,-.03,0)
yc<-txt[,2]+c(-.07,.04,.06,-.08)
txt.str<-c("CC","D1","D2","D3")
text(xc,yc,txt.str)

text(dat,labels=factor(rv$rv))

P<-c(1.8,.5)
rverts.triCC(P,Tr)

dat.fr<-data.frame(a=dat)
rverts.triCC(dat.fr,Tr)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rverts.triCM}}, \code{\link{rverts.tri.cent}}, and \code{\link{rverts.tri.nd}}
}
