% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsCSint}
\alias{NumArcsCSint}
\title{Number of arcs of  Central Similarity Proximity Catch Digraphs (CS-PCDs) - one interval case}
\usage{
NumArcsCSint(dat, t, c = 0.5, int)
}
\arguments{
\item{dat}{A set of 1D points which constitute the vertices of CS-PCD.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}; default=\code{0.5}.}

\item{int}{A \code{vector} of two real numbers representing an interval.}
}
\value{
Number of arcs for the CS-PCD whose vertices are the 1D data set, \code{dat},
with expansion parameter, \eqn{t>0}, and centrality parameter, \eqn{c \in (0,1)}.
}
\description{
Returns the number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs)
whose vertices are the 1D data set \code{dat} in the one-interval case.

The data points could be inside or outside the interval is \code{int}\eqn{=(a,b)}.

CS proximity region is constructed
with an expansion parameter \eqn{t>0} and a centrality parameter \eqn{c \in (0,1)}.
CS proximity region is constructed for both points inside and outside the interval, hence
the arcs may exist for all points inside or outside the interval.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
t<-2
a<-0; b<-10; int<-c(a,b)

n<-10
dat<-runif(n,a,b)
NumArcsCSint(dat,t,c,int)

NumArcsCSint(3,t,c,int)

NumArcsCSint(dat,t,c=.3,int)

NumArcsCSint(dat,t=1.5,c,int)

n<-10  #try also n<-20
dat<-runif(n,a,b)

NumArcsCSint(dat,t,c,int)

n<-10
dat<-runif(n,a,b)
NumArcsCSint(dat,t,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCSmid1D}}, \code{\link{NumArcsCSend1D}}, and \code{\link{NumArcsPEint}}
}
\author{
Elvan Ceyhan
}
